/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.commons.attls;

import lombok.Generated;
import org.zowe.commons.attls.AttlsContext;
import org.zowe.commons.attls.ContextIsNotInitializedException;
import org.zowe.commons.attls.Fips140;
import org.zowe.commons.attls.IoctlCallException;
import org.zowe.commons.attls.Protocol;
import org.zowe.commons.attls.SecurityType;
import org.zowe.commons.attls.StatConn;
import org.zowe.commons.attls.StatPolicy;
import org.zowe.commons.attls.UnknownEnumValueException;

public final class InboundAttls {
    private static ThreadLocal<AttlsContext> contexts = new ThreadLocal();
    private static boolean alwaysLoadCertificate;

    public static void init(int id) {
        contexts.set(new AttlsContext(id, alwaysLoadCertificate));
    }

    public static void dispose() {
        contexts.remove();
    }

    public static AttlsContext get() throws ContextIsNotInitializedException {
        AttlsContext context = contexts.get();
        if (context == null) {
            throw new ContextIsNotInitializedException();
        }
        return context;
    }

    public static void clean() throws ContextIsNotInitializedException {
        InboundAttls.get().clean();
    }

    public static StatPolicy getStatPolicy() throws ContextIsNotInitializedException, UnknownEnumValueException, IoctlCallException {
        return InboundAttls.get().getStatPolicy();
    }

    public static StatConn getStatConn() throws ContextIsNotInitializedException, UnknownEnumValueException, IoctlCallException {
        return InboundAttls.get().getStatConn();
    }

    public static Protocol getProtocol() throws ContextIsNotInitializedException, IoctlCallException, UnknownEnumValueException {
        return InboundAttls.get().getProtocol();
    }

    public static String getNegotiatedCipher2() throws ContextIsNotInitializedException, IoctlCallException {
        return InboundAttls.get().getNegotiatedCipher2();
    }

    public static SecurityType getSecurityType() throws ContextIsNotInitializedException, IoctlCallException, UnknownEnumValueException {
        return InboundAttls.get().getSecurityType();
    }

    public static String getUserId() throws ContextIsNotInitializedException, IoctlCallException {
        return InboundAttls.get().getUserId();
    }

    public static Fips140 getFips140() throws ContextIsNotInitializedException, IoctlCallException, UnknownEnumValueException {
        return InboundAttls.get().getFips140();
    }

    public static byte getFlags() throws ContextIsNotInitializedException, IoctlCallException {
        return InboundAttls.get().getFlags();
    }

    public static String getNegotiatedCipher4() throws ContextIsNotInitializedException, IoctlCallException {
        return InboundAttls.get().getNegotiatedCipher4();
    }

    public static byte[] getCertificate() throws ContextIsNotInitializedException, IoctlCallException {
        return InboundAttls.get().getCertificate();
    }

    public static void resetSession() throws ContextIsNotInitializedException, IoctlCallException {
        InboundAttls.get().resetSession();
    }

    public static void resetCipher() throws ContextIsNotInitializedException, IoctlCallException {
        InboundAttls.get().resetCipher();
    }

    @Generated
    private InboundAttls() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @Generated
    public static void setAlwaysLoadCertificate(boolean alwaysLoadCertificate) {
        InboundAttls.alwaysLoadCertificate = alwaysLoadCertificate;
    }
}

