/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.product.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.EventArgUtil;
import ch.qos.logback.classic.turbo.DuplicateMessageFilter;
import ch.qos.logback.core.spi.FilterReply;
import java.util.Objects;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Marker;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class ApimlDuplicateMessagesFilter
extends DuplicateMessageFilter {
    public FilterReply decide(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t) {
        String formattedMessage = this.getLogMessage(format, params, t);
        return super.decide(marker, logger, level, this.getMessageHash(formattedMessage), params, t);
    }

    private String getMessageHash(String message) {
        return String.valueOf(Objects.hashCode(message));
    }

    private String getLogMessage(String format, Object[] params, Throwable t) {
        FormattingTuple formattingTuple = this.getFormattedMessage(format, params, t);
        return formattingTuple.getMessage() + (formattingTuple.getThrowable() == null ? "" : "\n") + String.join((CharSequence)"\n", ExceptionUtils.getStackFrames((Throwable)formattingTuple.getThrowable()));
    }

    private FormattingTuple getFormattedMessage(String format, Object[] params, Throwable t) {
        if (params == null || params.length == 0) {
            return new FormattingTuple(format, params, t);
        }
        if (t == null) {
            Throwable throwable = EventArgUtil.extractThrowable((Object[])params);
            if (throwable == null) {
                return MessageFormatter.arrayFormat((String)format, (Object[])params);
            }
            return MessageFormatter.arrayFormat((String)format, (Object[])EventArgUtil.trimmedCopy((Object[])params), (Throwable)throwable);
        }
        return MessageFormatter.arrayFormat((String)format, (Object[])params, (Throwable)t);
    }
}

