/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.product.service;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import java.lang.management.ManagementFactory;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.LoggerFactory;
import org.zowe.apiml.message.core.MessageService;
import org.zowe.apiml.message.log.ApimlLogger;
import org.zowe.apiml.message.yaml.YamlMessageServiceInstance;

public class ServiceStartupEventHandler {
    public static final int DEFAULT_DELAY_FACTOR = 5;
    private final ApimlLogger apimlLog = ApimlLogger.of(ServiceStartupEventHandler.class, (MessageService)YamlMessageServiceInstance.getInstance());

    public void onServiceStartup(String serviceName, int delayFactor) {
        long uptime = ManagementFactory.getRuntimeMXBean().getUptime();
        this.apimlLog.log("org.zowe.apiml.common.serviceStarted", new Object[]{serviceName, (double)uptime / 1000.0});
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                String[] names;
                LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
                for (String name : names = new String[]{"com.netflix.discovery.DiscoveryClient", "com.netflix.discovery.shared.transport.decorator.RedirectingEurekaHttpClient"}) {
                    Logger logger = loggerContext.getLogger(name);
                    logger.setLevel(Level.ERROR);
                }
            }
        }, uptime * (long)delayFactor);
    }
}

