/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.product.logging;

import jakarta.annotation.Nonnull;
import java.lang.reflect.Field;
import lombok.Generated;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;
import org.zowe.apiml.message.core.MessageService;
import org.zowe.apiml.message.log.ApimlLogger;
import org.zowe.apiml.message.yaml.YamlMessageServiceInstance;
import org.zowe.apiml.product.logging.annotations.InjectApimlLogger;

@Component
public class ApimlLogInjector
implements BeanPostProcessor {
    public Object postProcessAfterInitialization(@Nonnull Object bean, @Nonnull String beanName) {
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, @Nonnull String name) {
        ReflectionUtils.doWithFields(bean.getClass(), field -> {
            ReflectionUtils.makeAccessible((Field)field);
            if (field.getAnnotation(InjectApimlLogger.class) != null) {
                Class<?> clazz = this.getClass(bean);
                ApimlLogger log = ApimlLogger.of(clazz, (MessageService)YamlMessageServiceInstance.getInstance());
                field.set(bean, log);
            }
        });
        return bean;
    }

    private Class<?> getClass(Object bean) {
        Class<Object> clazz = bean.getClass();
        String fullName = clazz.getName();
        int index = fullName.indexOf(36);
        if (index > -1) {
            String className = fullName.substring(0, index);
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                clazz = ApimlLogInjector.class;
            }
        }
        return clazz;
    }

    @Generated
    public ApimlLogInjector() {
    }
}

