/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.product.gateway;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.CacheRefreshedEvent;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.EurekaEvent;
import com.netflix.discovery.shared.Application;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.zowe.apiml.product.constants.CoreService;

public class AdditionalRegistrationGatewayRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdditionalRegistrationGatewayRegistry.class);
    @Value(value="${apiml.forwardHeader.trustedProxiesCacheTimeout:5m}")
    Duration registryExpiration;
    AtomicReference<Set<String>> additionalGatewayIpAddressesReference = new AtomicReference(Collections.emptySet());
    Cache<String, List<String>> knownAdditionalGateways;

    @PostConstruct
    public void init() {
        this.knownAdditionalGateways = CacheBuilder.newBuilder().expireAfterWrite(this.registryExpiration.toMillis(), TimeUnit.MILLISECONDS).build();
        log.debug("AdditionalRegistrationGatewayRegistry initialized");
    }

    public void registerCacheRefreshEventListener(DiscoveryClient additionalApimlRegistration) {
        additionalApimlRegistration.registerEventListener(event -> this.cacheRefreshEventHandler(event, additionalApimlRegistration));
        log.debug("AdditionalRegistrationGatewayRegistry refresh registered for additional registration: {}", (Object)additionalApimlRegistration.getEurekaClientConfig().getEurekaServerServiceUrls(null));
    }

    void cacheRefreshEventHandler(EurekaEvent event, DiscoveryClient additionalApimlRegistration) {
        if (event instanceof CacheRefreshedEvent) {
            Set additionalGateways = Stream.of(additionalApimlRegistration.getApplication(CoreService.GATEWAY.getServiceId()), additionalApimlRegistration.getApplication(CoreService.CLOUD_GATEWAY.getServiceId())).filter(Objects::nonNull).map(Application::getInstances).flatMap(Collection::stream).flatMap(this::processInstanceInfoForIpAddresses).collect(Collectors.toSet());
            log.debug("Additional registrations gateway ip addresses resolved: {}", additionalGateways);
            this.additionalGatewayIpAddressesReference.set(additionalGateways);
        }
    }

    private InetAddress[] getInetAddressesByName(String instanceId, String networkName) {
        try {
            return InetAddress.getAllByName(networkName);
        }
        catch (UnknownHostException e) {
            log.debug("Unknown host or address for instance {} by {}", new Object[]{instanceId, networkName, e});
            return new InetAddress[0];
        }
    }

    private Stream<String> processInstanceInfoForIpAddresses(InstanceInfo instanceInfo) {
        try {
            return ((List)this.knownAdditionalGateways.get((Object)instanceInfo.getInstanceId(), () -> {
                List addresses = Stream.of(this.getInetAddressesByName(instanceInfo.getInstanceId(), instanceInfo.getHostName()), this.getInetAddressesByName(instanceInfo.getInstanceId(), instanceInfo.getIPAddr())).filter(Objects::nonNull).flatMap(Stream::of).map(InetAddress::getHostAddress).distinct().collect(Collectors.toList());
                log.debug("Additional registrations gateway ip addresses for instance {} resolved: {}", (Object)instanceInfo.getInstanceId(), addresses);
                return addresses;
            })).stream();
        }
        catch (ExecutionException e) {
            log.debug("Unable to update additional gateway registry for instance {}.", (Object)instanceInfo, (Object)e);
            return Stream.empty();
        }
    }

    @Generated
    public AtomicReference<Set<String>> getAdditionalGatewayIpAddressesReference() {
        return this.additionalGatewayIpAddressesReference;
    }
}

