/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.product.logging;

import ch.qos.logback.classic.LoggerContext;
import java.time.ZoneId;
import java.util.TimeZone;
import javax.annotation.PostConstruct;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.zowe.apiml.message.log.ApimlLogger;
import org.zowe.apiml.product.logging.annotations.InjectApimlLogger;

@Component
public class LoggingTimezoneConfig {
    private static final String UT_COMMON_TIMEZONE_SET_LOG_KEY = "org.zowe.apiml.common.timezone.set";
    private static final String UT_COMMON_TIMEZONE_INVALID_LOG_KEY = "org.zowe.apiml.common.timezone.invalid";
    private static final String UTC_TIMEZONE = "UTC";
    private static final String LOGGING_TIMEZONE = "LOGGING_TIMEZONE";
    private static final String LOCAL = "LOCAL";
    private static final String TZ = "TZ";
    @InjectApimlLogger
    private ApimlLogger apimlLog = ApimlLogger.empty();
    @Value(value="${logging.timezone:UTC}")
    private String configuredTimezone;

    @PostConstruct
    public void init() {
        String timezone = this.determineTimezone();
        TimeZone.setDefault(TimeZone.getTimeZone(timezone));
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        loggerContext.putProperty(LOGGING_TIMEZONE, timezone);
        this.apimlLog.log(UT_COMMON_TIMEZONE_SET_LOG_KEY, new Object[]{timezone});
    }

    private String determineTimezone() {
        if (LOCAL.equalsIgnoreCase(this.configuredTimezone)) {
            String tzEnv = System.getenv(TZ);
            if (tzEnv != null && !tzEnv.isEmpty()) {
                try {
                    ZoneId.of(tzEnv);
                    return tzEnv;
                }
                catch (Exception e) {
                    this.apimlLog.log(UT_COMMON_TIMEZONE_INVALID_LOG_KEY, new Object[]{tzEnv});
                    return TimeZone.getDefault().getID();
                }
            }
            return TimeZone.getDefault().getID();
        }
        try {
            ZoneId.of(this.configuredTimezone);
            return this.configuredTimezone;
        }
        catch (Exception e) {
            this.apimlLog.log(UT_COMMON_TIMEZONE_INVALID_LOG_KEY, new Object[]{this.configuredTimezone});
            return UTC_TIMEZONE;
        }
    }
}

