/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.gzip;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.zip.GZIPOutputStream;
import org.zowe.apiml.gzip.GZipServletOutputStream;

public class GZipResponseWrapper
extends HttpServletResponseWrapper {
    private GZipServletOutputStream gzipOutputStream;
    private PrintWriter printWriter = null;
    private boolean disableFlushBuffer = false;

    public GZipResponseWrapper(HttpServletResponse response, GZIPOutputStream stream) {
        super(response);
        this.gzipOutputStream = new GZipServletOutputStream(stream);
    }

    public void close() throws IOException {
        if (this.printWriter != null) {
            this.printWriter.close();
        }
        if (this.gzipOutputStream != null) {
            this.gzipOutputStream.close();
        }
    }

    public void flushBuffer() throws IOException {
        this.flush();
        if (!this.disableFlushBuffer) {
            super.flushBuffer();
        }
    }

    public void flush() throws IOException {
        if (this.printWriter != null) {
            this.printWriter.flush();
        }
        if (this.gzipOutputStream != null) {
            this.gzipOutputStream.flush();
        }
    }

    public ServletOutputStream getOutputStream() {
        if (this.printWriter != null) {
            throw new IllegalStateException("PrintWriter obtained already - cannot get OutputStream");
        }
        return this.gzipOutputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.printWriter == null) {
            this.gzipOutputStream = new GZipServletOutputStream((OutputStream)this.getResponse().getOutputStream());
            this.printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)((Object)this.gzipOutputStream), this.getResponse().getCharacterEncoding()), true);
        }
        return this.printWriter;
    }

    public void setContentLength(int length) {
    }

    public void setDisableFlushBuffer(boolean disableFlushBuffer) {
        this.disableFlushBuffer = disableFlushBuffer;
    }
}

