/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.filter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import lombok.Generated;
import org.apache.catalina.connector.RequestFacade;
import org.apache.commons.lang3.ArrayUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.http.server.reactive.AbstractServerHttpRequest;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.SslInfo;
import org.springframework.stereotype.Component;
import org.springframework.web.server.adapter.DefaultServerWebExchange;
import org.springframework.web.server.i18n.LocaleContextResolver;
import org.springframework.web.server.session.DefaultWebSessionManager;
import org.springframework.web.server.session.WebSessionManager;
import org.zowe.apiml.message.core.Message;
import org.zowe.apiml.message.core.MessageService;
import org.zowe.commons.attls.AttlsContext;
import org.zowe.commons.attls.ContextIsNotInitializedException;
import org.zowe.commons.attls.InboundAttls;
import org.zowe.commons.attls.IoctlCallException;
import org.zowe.commons.attls.StatConn;
import org.zowe.commons.attls.UnknownEnumValueException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
@ConditionalOnProperty(name={"server.attls.enabled"}, havingValue="true")
public class AttlsHttpHandler
implements BeanPostProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AttlsHttpHandler.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final MessageService messageService;
    private final LocaleContextResolver localeContextResolver;
    private final WebSessionManager sessionManager = new DefaultWebSessionManager();
    private final ServerCodecConfigurer serverCodecConfigurer = ServerCodecConfigurer.create();

    private Mono<Void> writeError(ServerHttpRequest request, ServerHttpResponse response, String message) {
        DefaultServerWebExchange serverWebExchange = new DefaultServerWebExchange(request, response, this.sessionManager, this.serverCodecConfigurer, this.localeContextResolver);
        response.setRawStatusCode(Integer.valueOf(500));
        response.getHeaders().add("Content-Type", "application/json");
        DataBuffer buffer = serverWebExchange.getResponse().bufferFactory().wrap(message.getBytes(StandardCharsets.UTF_8));
        return serverWebExchange.getResponse().writeWith((Publisher)Flux.just((Object)buffer));
    }

    private String getMessage(String key) {
        Message message = this.messageService.createMessage(key, new Object[0]);
        try {
            return objectMapper.writeValueAsString((Object)message.mapToView());
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    Mono<Void> internalError(ServerHttpRequest request, ServerHttpResponse response) {
        return this.writeError(request, response, this.getMessage("org.zowe.apiml.common.internalServerError"));
    }

    Mono<Void> unsecureError(ServerHttpRequest request, ServerHttpResponse response) {
        return this.writeError(request, response, this.getMessage("org.zowe.apiml.security.common.attls.notSecure"));
    }

    ServerHttpRequest updateCertificate(ServerHttpRequest request, HttpServletRequest nativeRequest, byte[] rawCertificate) throws CertificateException {
        if (ArrayUtils.isEmpty((byte[])rawCertificate)) {
            return request;
        }
        String str = String.format("-----BEGIN CERTIFICATE-----\n%s\n-----END CERTIFICATE-----\n", Base64.getEncoder().encodeToString(rawCertificate));
        X509Certificate certificate = (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8)));
        X509Certificate[] certs = new X509Certificate[]{certificate};
        nativeRequest.setAttribute("jakarta.servlet.request.X509Certificate", (Object)certs);
        AttlsSslInfo sslInfo = AttlsSslInfo.builder().peerCertificates(certs).build();
        return request.mutate().sslInfo((SslInfo)sslInfo).build();
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof HttpHandler) {
            HttpHandler httpHandler = (HttpHandler)bean;
            return (request, response) -> {
                try {
                    AttlsContext attlsContext = InboundAttls.get();
                    if (attlsContext.getStatConn() != StatConn.SECURE) {
                        return this.unsecureError(request, response);
                    }
                    RequestFacade requestFacade = (RequestFacade)((AbstractServerHttpRequest)request).getNativeRequest();
                    requestFacade.setAttribute("attls", (Object)attlsContext);
                    request = this.updateCertificate(request, (HttpServletRequest)requestFacade, attlsContext.getCertificate());
                }
                catch (UnsatisfiedLinkError | CertificateException | ContextIsNotInitializedException | IoctlCallException | UnknownEnumValueException e) {
                    log.error("Cannot verify AT-TLS status", e);
                    return this.internalError(request, response);
                }
                return httpHandler.handle(request, response);
            };
        }
        return bean;
    }

    @Generated
    public AttlsHttpHandler(MessageService messageService, LocaleContextResolver localeContextResolver) {
        this.messageService = messageService;
        this.localeContextResolver = localeContextResolver;
    }

    static final class AttlsSslInfo
    implements SslInfo {
        private final String sessionId;
        private final X509Certificate[] peerCertificates;

        @Generated
        AttlsSslInfo(String sessionId, X509Certificate[] peerCertificates) {
            this.sessionId = sessionId;
            this.peerCertificates = peerCertificates;
        }

        @Generated
        public static AttlsSslInfoBuilder builder() {
            return new AttlsSslInfoBuilder();
        }

        @Generated
        public String getSessionId() {
            return this.sessionId;
        }

        @Generated
        public X509Certificate[] getPeerCertificates() {
            return this.peerCertificates;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AttlsSslInfo)) {
                return false;
            }
            AttlsSslInfo other = (AttlsSslInfo)o;
            String this$sessionId = this.getSessionId();
            String other$sessionId = other.getSessionId();
            if (this$sessionId == null ? other$sessionId != null : !this$sessionId.equals(other$sessionId)) {
                return false;
            }
            return Arrays.deepEquals(this.getPeerCertificates(), other.getPeerCertificates());
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sessionId = this.getSessionId();
            result = result * 59 + ($sessionId == null ? 43 : $sessionId.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getPeerCertificates());
            return result;
        }

        @Generated
        public String toString() {
            return "AttlsHttpHandler.AttlsSslInfo(sessionId=" + this.getSessionId() + ", peerCertificates=" + Arrays.deepToString(this.getPeerCertificates()) + ")";
        }

        @Generated
        public static class AttlsSslInfoBuilder {
            @Generated
            private String sessionId;
            @Generated
            private X509Certificate[] peerCertificates;

            @Generated
            AttlsSslInfoBuilder() {
            }

            @Generated
            public AttlsSslInfoBuilder sessionId(String sessionId) {
                this.sessionId = sessionId;
                return this;
            }

            @Generated
            public AttlsSslInfoBuilder peerCertificates(X509Certificate[] peerCertificates) {
                this.peerCertificates = peerCertificates;
                return this;
            }

            @Generated
            public AttlsSslInfo build() {
                return new AttlsSslInfo(this.sessionId, this.peerCertificates);
            }

            @Generated
            public String toString() {
                return "AttlsHttpHandler.AttlsSslInfo.AttlsSslInfoBuilder(sessionId=" + this.sessionId + ", peerCertificates=" + Arrays.deepToString(this.peerCertificates) + ")";
            }
        }
    }
}

