/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.product.web;

import jakarta.annotation.PostConstruct;
import java.io.FileDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.SocketChannel;
import lombok.Generated;
import org.apache.catalina.connector.Connector;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.http11.Http11NioProtocol;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.Nio2Channel;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.SocketEvent;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.stereotype.Component;
import org.zowe.apiml.exception.AttlsHandlerException;
import org.zowe.commons.attls.ContextIsNotInitializedException;
import org.zowe.commons.attls.InboundAttls;

@Component
@ConditionalOnProperty(name={"server.attlsServer.enabled"}, havingValue="true")
public class ApimlTomcatCustomizer
implements TomcatConnectorCustomizer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApimlTomcatCustomizer.class);
    private static final String INCOMPATIBLE_VERSION_MESSAGE = "AT-TLS-Incompatible configuration. Verify AT-TLS requirements: Java version, Tomcat version. Exception message: ";

    @PostConstruct
    public void afterPropertiesSet() {
        log.debug("AT-TLS mode is enabled");
        InboundAttls.setAlwaysLoadCertificate((boolean)true);
    }

    public void customize(Connector connector) {
        Http11NioProtocol protocolHandler = (Http11NioProtocol)connector.getProtocolHandler();
        try {
            Field handlerField = AbstractProtocol.class.getDeclaredField("handler");
            handlerField.setAccessible(true);
            ApimlAttlsHandler handler = (ApimlAttlsHandler)handlerField.get(protocolHandler);
            handler = new ApimlAttlsHandler(handler);
            Method method = AbstractProtocol.class.getDeclaredMethod("getEndpoint", new Class[0]);
            method.setAccessible(true);
            AbstractEndpoint abstractEndpoint = (AbstractEndpoint)method.invoke((Object)protocolHandler, new Object[0]);
            abstractEndpoint.setHandler(handler);
        }
        catch (Exception e) {
            throw new AttlsHandlerException("Not able to add handler.", e);
        }
    }

    public static class ApimlAttlsHandler<S>
    implements AbstractEndpoint.Handler<S> {
        private final AbstractEndpoint.Handler<S> handler;
        private static Field ASYNCHRONOUS_SOCKET_CHANNEL_FD;
        private static Field FILE_DESCRIPTOR_FD;
        private static Method SOCKET_CHANNEL_GET_FDVAL_METHOD;

        public ApimlAttlsHandler(AbstractEndpoint.Handler<S> handler) {
            this.handler = handler;
            try {
                Class<?> nioClazz = Class.forName("sun.nio.ch.SocketChannelImpl");
                SOCKET_CHANNEL_GET_FDVAL_METHOD = nioClazz.getMethod("getFDVal", new Class[0]);
                SOCKET_CHANNEL_GET_FDVAL_METHOD.setAccessible(true);
                Class<?> nio2Clazz = Class.forName("sun.nio.ch.AsynchronousSocketChannelImpl");
                ASYNCHRONOUS_SOCKET_CHANNEL_FD = nio2Clazz.getDeclaredField("fd");
                ASYNCHRONOUS_SOCKET_CHANNEL_FD.setAccessible(true);
                FILE_DESCRIPTOR_FD = FileDescriptor.class.getDeclaredField("fd");
                FILE_DESCRIPTOR_FD.setAccessible(true);
            }
            catch (ClassNotFoundException | NoSuchFieldException | NoSuchMethodException | SecurityException e) {
                throw new IllegalStateException(ApimlTomcatCustomizer.INCOMPATIBLE_VERSION_MESSAGE + e.getMessage(), e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AbstractEndpoint.Handler.SocketState process(SocketWrapperBase socketWrapperBase, SocketEvent status) {
            int fdVal = this.getFd(socketWrapperBase.getSocket());
            InboundAttls.init((int)fdVal);
            try {
                AbstractEndpoint.Handler.SocketState socketState = this.handler.process(socketWrapperBase, status);
                return socketState;
            }
            finally {
                try {
                    InboundAttls.clean();
                }
                catch (ContextIsNotInitializedException e) {
                    log.debug("Cannot clean AT-TLS context");
                }
                InboundAttls.dispose();
            }
        }

        private int getFd(Object socket) {
            try {
                if (socket instanceof NioChannel) {
                    NioChannel nioChannel = (NioChannel)socket;
                    return this.getFd(nioChannel);
                }
                if (socket instanceof Nio2Channel) {
                    Nio2Channel nio2Channel = (Nio2Channel)socket;
                    return this.getFdAsync(nio2Channel);
                }
                if (socket instanceof Long) {
                    Long socketNioChannel = (Long)socket;
                    return socketNioChannel.intValue();
                }
                throw new IllegalStateException("Socket " + String.valueOf(socket.getClass()) + " is not supported for AT-TLS");
            }
            catch (IllegalAccessException | IllegalArgumentException | IllegalStateException | InvocationTargetException e) {
                throw new IllegalStateException(ApimlTomcatCustomizer.INCOMPATIBLE_VERSION_MESSAGE + e.getMessage(), e);
            }
        }

        int getFd(NioChannel socket) throws InvocationTargetException, IllegalAccessException {
            SocketChannel socketChannel = socket.getIOChannel();
            if (socketChannel == null) {
                throw new IllegalStateException("Socket channel is not initialized");
            }
            return (Integer)SOCKET_CHANNEL_GET_FDVAL_METHOD.invoke((Object)socketChannel, new Object[0]);
        }

        int getFdAsync(Nio2Channel socket) throws IllegalAccessException {
            AsynchronousSocketChannel asch = socket.getIOChannel();
            if (asch == null) {
                throw new IllegalStateException("Asynchronous socket channel is not initialized");
            }
            FileDescriptor fd = (FileDescriptor)ASYNCHRONOUS_SOCKET_CHANNEL_FD.get(asch);
            if (fd == null) {
                throw new IllegalStateException("File descriptor is not set in the asynchronous socket channel");
            }
            return FILE_DESCRIPTOR_FD.getInt(fd);
        }

        @Generated
        public Object getGlobal() {
            return this.handler.getGlobal();
        }

        @Generated
        public void release(SocketWrapperBase<S> arg0) {
            this.handler.release(arg0);
        }

        @Generated
        public void pause() {
            this.handler.pause();
        }

        @Generated
        public void recycle() {
            this.handler.recycle();
        }

        static interface Overridden {
            public <S> AbstractEndpoint.Handler.SocketState process(SocketWrapperBase<S> var1, SocketEvent var2);
        }
    }
}

