/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.web.filter.OncePerRequestFilter;
import org.zowe.apiml.filter.AttlsErrorHandler;
import org.zowe.commons.attls.InboundAttls;

public class AttlsFilter
extends OncePerRequestFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AttlsFilter.class);

    protected void doFilterInternal(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull FilterChain filterChain) throws ServletException, IOException {
        try {
            byte[] certificate = InboundAttls.getCertificate();
            if (certificate != null && certificate.length > 0) {
                log.debug("Certificate length: {}", (Object)certificate.length);
                this.populateRequestWithCertificate(request, certificate);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Not possible to get certificate from AT-TLS context", (Throwable)e);
            AttlsErrorHandler.handleError(response, "Exception reading certificate");
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void populateRequestWithCertificate(HttpServletRequest request, byte[] rawCertificate) throws CertificateException {
        String str = String.format("-----BEGIN CERTIFICATE-----\n%s\n-----END CERTIFICATE-----\n", Base64.getEncoder().encodeToString(rawCertificate));
        X509Certificate certificate = (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8)));
        X509Certificate[] certs = new X509Certificate[]{certificate};
        request.setAttribute("jakarta.servlet.request.X509Certificate", (Object)certs);
    }
}

