/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.tomcat.util.codec.binary.Base64;
import org.springframework.web.filter.OncePerRequestFilter;
import org.zowe.apiml.filter.AttlsErrorHandler;
import org.zowe.commons.attls.InboundAttls;

public class AttlsFilter
extends OncePerRequestFilter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        block5: {
            try {
                if (InboundAttls.getCertificate() == null || InboundAttls.getCertificate().length <= 0) break block5;
                try {
                    this.populateRequestWithCertificate(request, InboundAttls.getCertificate());
                }
                finally {
                    InboundAttls.clean();
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"Not possible to get certificate from AT-TLS context", (Throwable)e);
                AttlsErrorHandler.handleError(response, "Exception reading certificate");
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void populateRequestWithCertificate(HttpServletRequest request, byte[] rawCertificate) throws CertificateException {
        byte[] encodedCert = Base64.encodeBase64((byte[])rawCertificate, (boolean)false);
        Object s = new String(encodedCert);
        s = "-----BEGIN CERTIFICATE-----\n" + (String)s + "\n-----END CERTIFICATE-----";
        X509Certificate certificate = (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(new ByteArrayInputStream(((String)s).getBytes()));
        X509Certificate[] certificates = new X509Certificate[]{certificate};
        request.setAttribute("javax.servlet.request.X509Certificate", (Object)certificates);
    }
}

