/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.product.web;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.catalina.connector.Connector;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.stereotype.Component;

@Component
public class TomcatKeyringFix
implements TomcatConnectorCustomizer {
    private static final Pattern KEYRING_PATTERN = Pattern.compile("^(safkeyring[^:]*):/{2,4}([^/]+)/(.+)$");
    private static final String KEYRING_PASSWORD = "password";
    @Value(value="${server.ssl.keyStore:#{null}}")
    protected String keyStore;
    @Value(value="${server.ssl.keyAlias:localhost}")
    protected String keyAlias;
    @Value(value="${server.ssl.keyStorePassword:#{null}}")
    protected char[] keyStorePassword;
    @Value(value="${server.ssl.keyPassword:#{null}}")
    protected char[] keyPassword;
    @Value(value="${server.ssl.trustStore:#{null}}")
    protected String trustStore;
    @Value(value="${server.ssl.trustStorePassword:#{null}}")
    protected char[] trustStorePassword;

    void fixDefaultCertificate(SSLHostConfig sslHostConfig) {
        Set originalSet = sslHostConfig.getCertificates();
        if (originalSet.isEmpty()) {
            return;
        }
        try {
            Field defaultCertificateField = sslHostConfig.getClass().getDeclaredField("defaultCertificate");
            defaultCertificateField.setAccessible(true);
            if (defaultCertificateField.get(sslHostConfig) == null) {
                defaultCertificateField.set(sslHostConfig, originalSet.iterator().next());
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException("Cannot update Tomcat SSL context", e);
        }
    }

    boolean isKeyring(String input) {
        if (input == null) {
            return false;
        }
        Matcher matcher = KEYRING_PATTERN.matcher(input);
        return matcher.matches();
    }

    static String formatKeyringUrl(String keyringUrl) {
        if (keyringUrl == null) {
            return null;
        }
        Matcher matcher = KEYRING_PATTERN.matcher((CharSequence)keyringUrl);
        if (matcher.matches()) {
            keyringUrl = matcher.group(1) + "://" + matcher.group(2) + "/" + matcher.group(3);
        }
        return keyringUrl;
    }

    public void customize(Connector connector) {
        Arrays.stream(connector.findSslHostConfigs()).forEach(sslConfig -> {
            this.fixDefaultCertificate((SSLHostConfig)sslConfig);
            if (this.isKeyring(this.keyStore)) {
                SSLHostConfigCertificate certificate = new SSLHostConfigCertificate(sslConfig, SSLHostConfigCertificate.Type.RSA);
                certificate.setCertificateKeystoreFile(TomcatKeyringFix.formatKeyringUrl(this.keyStore));
                certificate.setCertificateKeyAlias(this.keyAlias);
                if (this.keyStorePassword == null) {
                    certificate.setCertificateKeystorePassword(KEYRING_PASSWORD);
                }
                if (this.keyPassword == null) {
                    certificate.setCertificateKeyPassword(KEYRING_PASSWORD);
                }
                sslConfig.addCertificate(certificate);
            }
            if (this.isKeyring(this.trustStore)) {
                sslConfig.setTruststoreFile(TomcatKeyringFix.formatKeyringUrl(this.trustStore));
                if (this.trustStorePassword == null) {
                    sslConfig.setTruststorePassword(KEYRING_PASSWORD);
                }
            }
        });
    }
}

