/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.lang.NonNull;
import org.springframework.web.filter.OncePerRequestFilter;
import org.zowe.apiml.filter.AttlsErrorHandler;
import org.zowe.commons.attls.ContextIsNotInitializedException;
import org.zowe.commons.attls.InboundAttls;
import org.zowe.commons.attls.IoctlCallException;
import org.zowe.commons.attls.StatConn;
import org.zowe.commons.attls.UnknownEnumValueException;

public class SecureConnectionFilter
extends OncePerRequestFilter {
    protected void doFilterInternal(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull FilterChain filterChain) throws ServletException, IOException {
        try {
            if (InboundAttls.get() != null && InboundAttls.get().getStatConn() == StatConn.SECURE) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                AttlsErrorHandler.handleError(response, "Inbound AT-TLS context is not initialized or connection is not secure.");
            }
        }
        catch (UnsatisfiedLinkError | ContextIsNotInitializedException | IoctlCallException | UnknownEnumValueException e) {
            this.logger.error((Object)"Can't read from AT-TLS context", e);
            AttlsErrorHandler.handleError(response, "Connection is not secure. " + e.getMessage());
        }
    }
}

