/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.product.web;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.connector.Connector;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.ProtocolHandler;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.NioEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class TomcatAcceptFixConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TomcatAcceptFixConfig.class);
    @Value(value="${server.tomcat.retryRebindTimeoutSecs:10}")
    int retryRebindTimeoutSecs;
    private static final Field ENDPOINT_FIELD;
    private static final Field NIO_SOCKET_FIELD;
    private static final MethodHandle IMPL_CLOSE_SELECTABGLE_CHANNEL_HANLE;
    private static final MethodHandle IMPL_CONFIGURE_BLOCKING;
    private static final AtomicBoolean running;

    private void update(AbstractProtocol<?> abstractProtocol, Runnable rebindHandler) {
        try {
            AbstractEndpoint abstractEndpoint = (AbstractEndpoint)ENDPOINT_FIELD.get(abstractProtocol);
            if (abstractEndpoint instanceof NioEndpoint) {
                ServerSocketChannel serverSocketChannel = (ServerSocketChannel)NIO_SOCKET_FIELD.get(abstractEndpoint);
                serverSocketChannel = new FixedServerSocketChannel(serverSocketChannel, abstractEndpoint, rebindHandler);
                NIO_SOCKET_FIELD.set(abstractEndpoint, serverSocketChannel);
            } else {
                log.warn("Unsupported protocol: {}", (Object)abstractEndpoint.getClass().getName());
            }
        }
        catch (Exception e) {
            log.warn("Cannot update connector to handle errors on socket accepting", (Throwable)e);
        }
    }

    private void update(Connector connector) {
        ProtocolHandler protocolHandler = connector.getProtocolHandler();
        if (protocolHandler instanceof AbstractProtocol) {
            this.update((AbstractProtocol)protocolHandler, () -> this.update(connector));
        } else {
            log.warn("Unsupported protocol handler: {}", (Object)protocolHandler.getClass().getName());
        }
    }

    @Bean
    public TomcatConnectorCustomizer tomcatAcceptorFix() {
        return connector -> connector.addLifecycleListener(event -> {
            if (event.getLifecycle().getState() == LifecycleState.STARTED) {
                this.update(connector);
            }
        });
    }

    @PreDestroy
    public void stopping() {
        running.set(false);
    }

    static {
        running = new AtomicBoolean(true);
        try {
            ENDPOINT_FIELD = AbstractProtocol.class.getDeclaredField("endpoint");
            NIO_SOCKET_FIELD = NioEndpoint.class.getDeclaredField("serverSock");
            Method implCloseSelectableChannel = AbstractSelectableChannel.class.getDeclaredMethod("implCloseSelectableChannel", new Class[0]);
            implCloseSelectableChannel.setAccessible(true);
            IMPL_CLOSE_SELECTABGLE_CHANNEL_HANLE = MethodHandles.lookup().unreflect(implCloseSelectableChannel);
            Method implConfigureBlocking = AbstractSelectableChannel.class.getDeclaredMethod("implConfigureBlocking", Boolean.TYPE);
            implConfigureBlocking.setAccessible(true);
            IMPL_CONFIGURE_BLOCKING = MethodHandles.lookup().unreflect(implConfigureBlocking);
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | SecurityException e) {
            throw new IllegalStateException("Unknown structure of protocols", e);
        }
        ENDPOINT_FIELD.setAccessible(true);
        NIO_SOCKET_FIELD.setAccessible(true);
    }

    class FixedServerSocketChannel
    extends ServerSocketChannel {
        private final ServerSocketChannel socket;
        private final AbstractEndpoint<?, ?> abstractEndpoint;
        private final AtomicInteger state;
        private final Runnable rebindHandler;

        FixedServerSocketChannel(ServerSocketChannel socket, AbstractEndpoint<?, ?> abstractEndpoint, Runnable rebindHandler) {
            super(socket.provider());
            this.state = new AtomicInteger();
            this.socket = socket;
            this.abstractEndpoint = abstractEndpoint;
            this.rebindHandler = rebindHandler;
        }

        @Override
        protected void implCloseSelectableChannel() throws IOException {
            try {
                IMPL_CLOSE_SELECTABGLE_CHANNEL_HANLE.invoke(this.socket);
            }
            catch (IOException | RuntimeException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new IllegalStateException(t);
            }
        }

        @Override
        protected void implConfigureBlocking(boolean block) throws IOException {
            try {
                IMPL_CONFIGURE_BLOCKING.invoke(this.socket, block);
            }
            catch (IOException | RuntimeException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new IllegalStateException(t);
            }
        }

        private void bindWithWait() throws IOException, InterruptedException {
            while (true) {
                try {
                    this.abstractEndpoint.bind();
                }
                catch (Throwable t) {
                    log.debug("Cannot rebind socket", t);
                    if (!running.get()) {
                        throw new IOException("Application is stopping during the attempt to rebind the socket", t);
                    }
                    Thread.sleep(TomcatAcceptFixConfig.this.retryRebindTimeoutSecs);
                    continue;
                }
                break;
            }
        }

        private synchronized void rebind(int stateBefore) throws IOException {
            if (this.state.compareAndSet(stateBefore, stateBefore + 1)) {
                try {
                    this.socket.close();
                    this.bindWithWait();
                    this.rebindHandler.run();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    throw new IOException("Cannot rebind the port", e);
                }
            }
        }

        @Override
        public SocketChannel accept() throws IOException {
            int stateBefore = this.state.get();
            try {
                return this.socket.accept();
            }
            catch (IOException ioe) {
                if (ioe.getMessage().contains("EDC5122I")) {
                    log.debug("The TCP/IP stack was probably restarted. The socket of Tomcat will rebind.");
                    this.rebind(stateBefore);
                    return this.socket.accept();
                }
                throw ioe;
            }
        }

        @Override
        @Generated
        public ServerSocketChannel bind(SocketAddress arg0, int arg1) throws IOException {
            return this.socket.bind(arg0, arg1);
        }

        @Override
        @Generated
        public <T> ServerSocketChannel setOption(SocketOption<T> arg0, T arg1) throws IOException {
            return this.socket.setOption((SocketOption)arg0, (Object)arg1);
        }

        @Override
        @Generated
        public ServerSocket socket() {
            return this.socket.socket();
        }

        @Override
        @Generated
        public SocketAddress getLocalAddress() throws IOException {
            return this.socket.getLocalAddress();
        }

        @Override
        @Generated
        public <T> T getOption(SocketOption<T> arg0) throws IOException {
            return this.socket.getOption(arg0);
        }

        @Override
        @Generated
        public Set<SocketOption<?>> supportedOptions() {
            return this.socket.supportedOptions();
        }
    }

    private static interface Overridden {
        public SocketChannel accept() throws IOException;

        public int validOps();

        public ServerSocketChannel bind(SocketAddress var1) throws IOException;

        public SelectorProvider provider();

        public boolean isRegistered();

        public SelectionKey keyFor(Selector var1);

        public SelectionKey register(Selector var1, int var2, Object var3);

        public void implCloseChannel() throws IOException;

        public boolean isBlocking();

        public Object blockingLock();

        public SelectableChannel configureBlocking(boolean var1) throws IOException;

        public SelectionKey register(Selector var1, int var2) throws ClosedChannelException;

        public void close() throws IOException;

        public boolean isOpen();
    }
}

