/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.filter;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.tomcat.util.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;
import org.zowe.apiml.filter.AttlsErrorHandler;
import org.zowe.commons.attls.InboundAttls;

public class AttlsFilter
extends OncePerRequestFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AttlsFilter.class);

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        byte[] rawCertificate = null;
        try {
            rawCertificate = InboundAttls.getCertificate();
        }
        catch (Exception e) {
            log.error("Not possible to get rawCertificate from AT-TLS context", (Throwable)e);
            AttlsErrorHandler.handleError(response, "Exception reading rawCertificate");
        }
        if (rawCertificate != null && rawCertificate.length > 0) {
            log.debug("Certificate length: {}", (Object)rawCertificate.length);
            try {
                this.populateRequestWithCertificate(request, rawCertificate);
            }
            catch (CertificateException ce) {
                log.error("Cannot process rawCertificate: {}\n{}", (Object)ce.getMessage(), (Object)this.convert(rawCertificate));
                AttlsErrorHandler.handleError(response, "Exception reading rawCertificate");
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private String convert(byte[] rawCertificate) {
        StringBuilder sb = new StringBuilder();
        sb.append("-----BEGIN CERTIFICATE-----\n");
        sb.append(Base64.encodeBase64String((byte[])rawCertificate));
        sb.append("\n-----END CERTIFICATE-----");
        return sb.toString();
    }

    public void populateRequestWithCertificate(HttpServletRequest request, byte[] rawCertificate) throws CertificateException {
        X509Certificate certificate = (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(new ByteArrayInputStream(this.convert(rawCertificate).getBytes(StandardCharsets.UTF_8)));
        X509Certificate[] certificates = new X509Certificate[]{certificate};
        request.setAttribute("javax.servlet.request.X509Certificate", (Object)certificates);
    }
}

