/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.filter;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tomcat.util.codec.binary.Base64;
import org.springframework.web.filter.OncePerRequestFilter;
import org.zowe.apiml.filter.AttlsErrorHandler;
import org.zowe.commons.attls.InboundAttls;

public class AttlsFilter
extends OncePerRequestFilter {
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            byte[] certificate = InboundAttls.getCertificate();
            if (certificate != null && certificate.length > 0) {
                this.populateRequestWithCertificate(request, certificate);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Not possible to get certificate from AT-TLS context", (Throwable)e);
            AttlsErrorHandler.handleError(response, "Exception reading certificate");
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void populateRequestWithCertificate(HttpServletRequest request, byte[] rawCertificate) throws CertificateException {
        StringBuilder sb = new StringBuilder();
        sb.append("-----BEGIN CERTIFICATE-----\n");
        sb.append(Base64.encodeBase64String((byte[])rawCertificate));
        sb.append("\n-----END CERTIFICATE-----");
        X509Certificate certificate = (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(new ByteArrayInputStream(sb.toString().getBytes(StandardCharsets.UTF_8)));
        X509Certificate[] certificates = new X509Certificate[]{certificate};
        request.setAttribute("javax.servlet.request.X509Certificate", (Object)certificates);
    }
}

