/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.security.common.util;

import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import java.io.FileInputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.interfaces.RSAPublicKey;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.zowe.apiml.security.HttpsConfig;
import org.zowe.apiml.security.SecurityUtils;

public class JWTTestUtils {
    public static String createZoweJwtToken(String username, String domain, String ltpaToken, HttpsConfig config) {
        return JWTTestUtils.createToken(username, domain, ltpaToken, config, "APIML");
    }

    public static String createZosmfJwtToken(String username, String domain, String ltpaToken, HttpsConfig config) {
        return JWTTestUtils.createToken(username, domain, ltpaToken, config, "zOSMF");
    }

    public static String createToken(String username, String domain, String ltpaToken, HttpsConfig config, String issuer) {
        long now = System.currentTimeMillis();
        long expiration = now + 100000L;
        PrivateKey jwtSecret = SecurityUtils.loadKey((HttpsConfig)config);
        return Jwts.builder().subject(username).claim("dom", (Object)domain).claim("ltpa", (Object)ltpaToken).issuedAt(new Date(now)).expiration(new Date(expiration)).issuer(issuer).id(UUID.randomUUID().toString()).signWith((Key)jwtSecret).compact();
    }

    public static String createTokenWithUserFields() {
        Instant now = Instant.now();
        JwkAndSet jwkAndSet = JWTTestUtils.loadPrivateKey("../keystore/localhost/localhost.keystore.p12", "localhost", "password");
        return ((JwtBuilder)((JwtBuilder.BuilderHeader)Jwts.builder().header().keyId("Lcxckkor94qkrunxHP7Tkib547rzmkXvsYV-nc6U-N4")).and()).subject("oidc.username").claim("email", (Object)"username@oidc.org").claim("nullValue", null).claim("org", Map.of("name", "openmainframe", "dep", Map.of("name", "zowe", "team", "apiml", "contributor", "contributor@apiml.zowe", "nickname", ""))).claim("memberOf", List.of("openmainframe", "zowe", "apiml")).claim("groups", Map.of("memberOf", List.of("openmainframe", "zowe", "apiml"))).issuedAt(Date.from(now)).expiration(Date.from(now.plusSeconds(1200L))).issuer("API ML").id(UUID.randomUUID().toString()).signWith((Key)jwkAndSet.privateKey()).compact();
    }

    public static JwkAndSet loadPrivateKey(String path, String alias, String password) throws Exception {
        KeyStore ks = KeyStore.getInstance("PKCS12");
        try (FileInputStream fis = new FileInputStream(path);){
            ks.load(fis, password.toCharArray());
        }
        Key key = ks.getKey(alias, password.toCharArray());
        Certificate cert = ks.getCertificate(alias);
        PublicKey pubKey = cert.getPublicKey();
        if (pubKey instanceof RSAPublicKey) {
            RSAPublicKey rsaPublicKey = (RSAPublicKey)pubKey;
            JsonWebKey jwk = JsonWebKey.Factory.newJwk((Key)rsaPublicKey);
            jwk.setKeyId("Lcxckkor94qkrunxHP7Tkib547rzmkXvsYV-nc6U-N4");
            return new JwkAndSet((PrivateKey)key, new JsonWebKeySet(new JsonWebKey[]{jwk}));
        }
        return new JwkAndSet((PrivateKey)key, null);
    }

    public record JwkAndSet(PrivateKey privateKey, JsonWebKeySet jwkSet) {
    }
}

