/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.security.common.login;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.stereotype.Component;
import org.zowe.apiml.security.common.config.AuthConfigurationProperties;
import org.zowe.apiml.security.common.token.TokenAuthentication;
import org.zowe.apiml.util.CookieUtil;

@Component
public class SuccessfulLoginHandler
implements AuthenticationSuccessHandler {
    private final AuthConfigurationProperties authConfigurationProperties;

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        TokenAuthentication tokenAuthentication = (TokenAuthentication)authentication;
        String token = tokenAuthentication.getCredentials();
        this.setCookie(token, response);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    private void setCookie(String token, HttpServletResponse response) {
        AuthConfigurationProperties.CookieProperties cp = this.authConfigurationProperties.getCookieProperties();
        String cookieHeader = CookieUtil.setCookieHeader((String)cp.getCookieName(), (String)token, (String)cp.getCookieComment(), (String)cp.getCookiePath(), (String)cp.getCookieSameSite().getValue(), (Integer)cp.getCookieMaxAge(), (boolean)true, (boolean)cp.isCookieSecure());
        response.addHeader("Set-Cookie", cookieHeader);
    }

    @Generated
    public SuccessfulLoginHandler(AuthConfigurationProperties authConfigurationProperties) {
        this.authConfigurationProperties = authConfigurationProperties;
    }
}

