/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.security.common.filter;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.authentication.preauth.x509.X509AuthenticationFilter;

public class ApimlX509Filter
extends X509AuthenticationFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApimlX509Filter.class);
    private static final String ATTRNAME_CLIENT_AUTH_X509_CERTIFICATE = "client.auth.X509Certificate";
    private static final String ATTRNAME_JAVAX_SERVLET_REQUEST_X509_CERTIFICATE = "javax.servlet.request.X509Certificate";
    private static final String LOG_FORMAT_FILTERING_CERTIFICATES = "Filtering certificates: {} -> {}";
    private final Set<String> publicKeyCertificatesBase64;
    Predicate<X509Certificate> certificateForClientAuth = crt -> !this.getPublicKeyCertificatesBase64().contains(this.base64EncodePublicKey((X509Certificate)crt));
    Predicate<X509Certificate> notCertificateForClientAuth = crt -> this.getPublicKeyCertificatesBase64().contains(this.base64EncodePublicKey((X509Certificate)crt));

    public Set<String> getPublicKeyCertificatesBase64() {
        return this.publicKeyCertificatesBase64;
    }

    private void categorizeCerts(ServletRequest request) {
        X509Certificate[] certs = (X509Certificate[])request.getAttribute(ATTRNAME_JAVAX_SERVLET_REQUEST_X509_CERTIFICATE);
        if (certs != null) {
            request.setAttribute(ATTRNAME_CLIENT_AUTH_X509_CERTIFICATE, (Object)this.selectCerts(certs, this.certificateForClientAuth));
            request.setAttribute(ATTRNAME_JAVAX_SERVLET_REQUEST_X509_CERTIFICATE, (Object)this.selectCerts(certs, this.notCertificateForClientAuth));
            log.debug(LOG_FORMAT_FILTERING_CERTIFICATES, (Object)ATTRNAME_CLIENT_AUTH_X509_CERTIFICATE, request.getAttribute(ATTRNAME_CLIENT_AUTH_X509_CERTIFICATE));
            log.debug(LOG_FORMAT_FILTERING_CERTIFICATES, (Object)ATTRNAME_JAVAX_SERVLET_REQUEST_X509_CERTIFICATE, request.getAttribute(ATTRNAME_JAVAX_SERVLET_REQUEST_X509_CERTIFICATE));
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.categorizeCerts(request);
        super.doFilter(request, response, chain);
    }

    private X509Certificate[] selectCerts(X509Certificate[] certs, Predicate<X509Certificate> test) {
        return Arrays.stream(certs).filter(test).collect(Collectors.toList()).toArray(new X509Certificate[0]);
    }

    public String base64EncodePublicKey(X509Certificate cert) {
        return Base64.getEncoder().encodeToString(cert.getPublicKey().getEncoded());
    }

    public void setCertificateForClientAuth(Predicate<X509Certificate> certificateForClientAuth) {
        this.certificateForClientAuth = certificateForClientAuth;
    }

    public void setNotCertificateForClientAuth(Predicate<X509Certificate> notCertificateForClientAuth) {
        this.notCertificateForClientAuth = notCertificateForClientAuth;
    }

    @Generated
    public ApimlX509Filter(Set<String> publicKeyCertificatesBase64) {
        this.publicKeyCertificatesBase64 = publicKeyCertificatesBase64;
    }
}

