/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.security.common.login;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;

public abstract class NonCompulsoryAuthenticationProcessingFilter
extends AbstractAuthenticationProcessingFilter {
    protected NonCompulsoryAuthenticationProcessingFilter(String defaultFilterProcessesUrl) {
        super(defaultFilterProcessesUrl);
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (!this.requiresAuthentication(request, response)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Authentication authResult = null;
        try {
            authResult = this.attemptAuthentication(request, response);
        }
        catch (AuthenticationException failed) {
            this.unsuccessfulAuthentication(request, response, failed);
            return;
        }
        if (authResult == null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        this.successfulAuthentication(request, response, chain, authResult);
    }
}

