/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.security.common.auth.saf;

import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;
import org.zowe.apiml.security.common.auth.saf.SafResourceAccessDummy;
import org.zowe.apiml.security.common.auth.saf.SafResourceAccessEndpoint;
import org.zowe.apiml.security.common.auth.saf.SafResourceAccessSaf;
import org.zowe.apiml.security.common.auth.saf.SafResourceAccessVerifying;

@Configuration
public class SafResourceAccessConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SafResourceAccessConfig.class);
    private static final String ENDPOINT = "endpoint";
    private static final String NATIVE = "native";
    private static final String DUMMY = "dummy";
    private static final String[] PROVIDERS = new String[]{"endpoint", "native", "dummy"};
    @Value(value="${apiml.security.authorization.provider:}")
    private String provider;
    @Value(value="${apiml.security.authorization.endpoint.enabled:false}")
    private boolean endpointEnabled;

    protected SafResourceAccessVerifying createEndpoint(RestTemplate restTemplate) {
        return new SafResourceAccessEndpoint(restTemplate);
    }

    protected SafResourceAccessVerifying createNative() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, NoSuchFieldException {
        return new SafResourceAccessSaf();
    }

    protected SafResourceAccessVerifying createDummy() throws IOException {
        return new SafResourceAccessDummy();
    }

    private SafResourceAccessVerifying create(RestTemplate restTemplate, String type, boolean force) {
        switch (StringUtils.lowerCase((String)type)) {
            case "endpoint": {
                if (this.endpointEnabled || force) {
                    return this.createEndpoint(restTemplate);
                }
                return null;
            }
            case "native": {
                try {
                    return this.createNative();
                }
                catch (Exception e) {
                    log.debug("API PlatformAccessControl is not available", (Throwable)e);
                    return null;
                }
            }
            case "dummy": {
                try {
                    return this.createDummy();
                }
                catch (Exception e) {
                    log.debug("saf.yml nor mock-saf.yml is not available", (Throwable)e);
                    return null;
                }
            }
        }
        throw new IllegalArgumentException(String.format("Unknown provider to check SAF resource '%s', use one from %s", type, Arrays.toString(PROVIDERS)));
    }

    @Bean
    public SafResourceAccessVerifying safResourceAccessVerifying(RestTemplate restTemplate) {
        if (!StringUtils.isEmpty((CharSequence)this.provider)) {
            return this.create(restTemplate, this.provider, true);
        }
        for (String type : PROVIDERS) {
            SafResourceAccessVerifying srv = this.create(restTemplate, type, false);
            if (srv == null) continue;
            return srv;
        }
        return null;
    }
}

