/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.security.common.auth.saf;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.zowe.apiml.security.common.auth.saf.PlatformErrorType;

public enum PlatformAckErrno {
    EACCES("EACCES", 111, "Permission is denied; the specified password is incorrect", PlatformErrorType.DEFAULT),
    EINVAL("EINVAL", 121, "Invalid input parameters", PlatformErrorType.DEFAULT),
    EMVSSAF2ERR("EMVSSAF2ERR", 164, "An error occurred in the security product", PlatformErrorType.INTERNAL),
    ENOSYS("ENOSYS", 134, "The function is not supported on this system", PlatformErrorType.INTERNAL),
    EPERM("EPERM", 139, "The user does not have the access specified to the resource or the calling address space is not authorized to use this service or a load from a not program-controlled library was done in the address space", PlatformErrorType.ERRNO2_REQUIRED),
    ESRCH("ESRCH", 143, "The user ID or resource is not defined to the security product", PlatformErrorType.ERRNO2_REQUIRED);

    private static final Map<Integer, PlatformAckErrno> BY_ERRNO;
    public final String shortErrorName;
    public final int errno;
    public final String explanation;
    public final PlatformErrorType errorType;

    public static PlatformAckErrno valueOfErrno(int errno) {
        return BY_ERRNO.getOrDefault(errno, null);
    }

    @Generated
    private PlatformAckErrno(String shortErrorName, int errno, String explanation, PlatformErrorType errorType) {
        this.shortErrorName = shortErrorName;
        this.errno = errno;
        this.explanation = explanation;
        this.errorType = errorType;
    }

    static {
        BY_ERRNO = new HashMap<Integer, PlatformAckErrno>();
        for (PlatformAckErrno e : PlatformAckErrno.values()) {
            BY_ERRNO.put(e.errno, e);
        }
    }
}

