/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.security.common.auth.saf;

import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.web.client.RestTemplate;
import org.zowe.apiml.security.common.auth.saf.SafResourceAccessVerifying;

public class SafResourceAccessEndpoint
implements SafResourceAccessVerifying {
    private static final String URL_VARIABLE_SUFFIX = "/{userId}/{class}/{entity}/{level}";
    @Value(value="${apiml.security.authorization.endpoint.url:'http://localhost:8542/saf-auth'}")
    private String endpointUrl;
    private final RestTemplate restTemplate;

    @Override
    public boolean hasSafResourceAccess(Authentication authentication, String resourceClass, String resourceName, String accessLevel) {
        Response response = (Response)this.restTemplate.getForObject(this.endpointUrl + URL_VARIABLE_SUFFIX, Response.class, new Object[]{authentication.getName(), resourceClass, resourceName, accessLevel});
        return response != null && !response.isError() && response.isAuthorized();
    }

    @Generated
    public SafResourceAccessEndpoint(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public static class Response {
        private boolean authorized;
        private boolean error;
        private String message;

        @Generated
        public boolean isAuthorized() {
            return this.authorized;
        }

        @Generated
        public boolean isError() {
            return this.error;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public void setAuthorized(boolean authorized) {
            this.authorized = authorized;
        }

        @Generated
        public void setError(boolean error) {
            this.error = error;
        }

        @Generated
        public void setMessage(String message) {
            this.message = message;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Response)) {
                return false;
            }
            Response other = (Response)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isAuthorized() != other.isAuthorized()) {
                return false;
            }
            if (this.isError() != other.isError()) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Response;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAuthorized() ? 79 : 97);
            result = result * 59 + (this.isError() ? 79 : 97);
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SafResourceAccessEndpoint.Response(authorized=" + this.isAuthorized() + ", error=" + this.isError() + ", message=" + this.getMessage() + ")";
        }

        @Generated
        public Response(boolean authorized, boolean error, String message) {
            this.authorized = authorized;
            this.error = error;
            this.message = message;
        }
    }
}

