/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.security.common.auth;

import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.zowe.apiml.message.core.Message;
import org.zowe.apiml.message.core.MessageService;

@ControllerAdvice
public class SecurityControllerExceptionHandler {
    private static final String FORBIDDEN_MESSAGE_KEY = "org.zowe.apiml.security.forbidden";
    private final MessageService messageService;

    @ExceptionHandler(value={AccessDeniedException.class})
    public ResponseEntity<Object> handleAccessDeniedException(AccessDeniedException ex) {
        Message message = this.messageService.createMessage(FORBIDDEN_MESSAGE_KEY, new Object[]{ex.getMessage()});
        return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).contentType(MediaType.APPLICATION_JSON).body((Object)message);
    }

    @Generated
    public SecurityControllerExceptionHandler(MessageService messageService) {
        this.messageService = messageService;
    }
}

