/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.security.common.login;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.stereotype.Component;
import org.zowe.apiml.security.common.config.AuthConfigurationProperties;
import org.zowe.apiml.security.common.token.TokenAuthentication;

@Component
public class SuccessfulLoginHandler
implements AuthenticationSuccessHandler {
    private final AuthConfigurationProperties authConfigurationProperties;

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        TokenAuthentication tokenAuthentication = (TokenAuthentication)authentication;
        String token = tokenAuthentication.getCredentials();
        this.setCookie(token, response);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    private void setCookie(String token, HttpServletResponse response) {
        Cookie tokenCookie = new Cookie(this.authConfigurationProperties.getCookieProperties().getCookieName(), token);
        tokenCookie.setComment(this.authConfigurationProperties.getCookieProperties().getCookieComment());
        tokenCookie.setPath(this.authConfigurationProperties.getCookieProperties().getCookiePath());
        tokenCookie.setHttpOnly(true);
        tokenCookie.setMaxAge(this.authConfigurationProperties.getCookieProperties().getCookieMaxAge().intValue());
        tokenCookie.setSecure(this.authConfigurationProperties.getCookieProperties().isCookieSecure());
        response.addCookie(tokenCookie);
    }

    @Generated
    public SuccessfulLoginHandler(AuthConfigurationProperties authConfigurationProperties) {
        this.authConfigurationProperties = authConfigurationProperties;
    }
}

