/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.security.common.auth;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public enum AuthenticationScheme {
    BYPASS("bypass"),
    ZOWE_JWT("zoweJwt"),
    HTTP_BASIC_PASSTICKET("httpBasicPassTicket"),
    ZOSMF("zosmf");

    private final String scheme;
    private static Map<String, AuthenticationScheme> schemeToEnum;

    private AuthenticationScheme(String scheme) {
        this.scheme = scheme;
    }

    public String toString() {
        return this.scheme;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AuthenticationScheme fromScheme(String scheme) {
        if (schemeToEnum != null) {
            return schemeToEnum.get(scheme);
        }
        Class<AuthenticationScheme> clazz = AuthenticationScheme.class;
        synchronized (AuthenticationScheme.class) {
            if (schemeToEnum != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return schemeToEnum.get(scheme);
            }
            HashMap<String, AuthenticationScheme> map = new HashMap<String, AuthenticationScheme>();
            for (AuthenticationScheme as : AuthenticationScheme.values()) {
                map.put(as.scheme, as);
            }
            schemeToEnum = Collections.unmodifiableMap(map);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return schemeToEnum.get(scheme);
        }
    }

    @Generated
    public String getScheme() {
        return this.scheme;
    }
}

