/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.extension;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class ZoweRuntimeEnvironment {
    static final String INSTALLED_EXTENSIONS_ENV = "ZWE_INSTALLED_COMPONENTS";
    static final String ENABLED_EXTENSIONS_ENV = "ZWE_ENABLED_COMPONENTS";
    static final String WORKSPACE_DIR_ENV = "ZWE_zowe_workspaceDirectory";
    static final String COMPONENTS_APP_SERVER_DIR_ENV = "ZWE_components_app_server_pluginsDir";
    static final String PLUGINS_DIR_ENV = "ZWED_pluginsDir";
    static final String EXTENSION_DIR_ENV = "ZWE_zowe_extensionDirectory";
    static final String PRIVATE_WORKSPACE_ENV = "ZWE_PRIVATE_WORKSPACE_ENV_DIR";

    public static ZoweRuntimeEnvironment defaultEnv() {
        return new ZoweRuntimeEnvironment();
    }

    Optional<String> getPluginsDir() {
        String pluginsDir = System.getenv(PLUGINS_DIR_ENV);
        String componentsAppServerPluginsDir = System.getenv(COMPONENTS_APP_SERVER_DIR_ENV);
        String workspaceDir = System.getenv(WORKSPACE_DIR_ENV);
        if (StringUtils.isNotEmpty((CharSequence)pluginsDir)) {
            return Optional.of(pluginsDir);
        }
        if (StringUtils.isNotEmpty((CharSequence)componentsAppServerPluginsDir)) {
            return Optional.of(componentsAppServerPluginsDir);
        }
        if (StringUtils.isNotEmpty((CharSequence)workspaceDir)) {
            return Optional.of(workspaceDir);
        }
        return Optional.empty();
    }

    private List<String> getComponents(String env) {
        return Optional.ofNullable(env).map(installed -> installed.split(",")).map(Arrays::asList).orElse(Collections.emptyList());
    }

    List<String> getInstalledComponents() {
        return this.getComponents(System.getenv(INSTALLED_EXTENSIONS_ENV));
    }

    List<String> getEnabledComponents() {
        return this.getComponents(System.getenv(ENABLED_EXTENSIONS_ENV));
    }

    String getExtensionDirectory() {
        return System.getenv(EXTENSION_DIR_ENV);
    }

    String getWorkspaceDirectory() {
        return System.getenv(PRIVATE_WORKSPACE_ENV);
    }

    @Generated
    public ZoweRuntimeEnvironment() {
    }
}

