/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.extension;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zowe.apiml.extension.ExtensionDefinition;
import org.zowe.apiml.extension.ExtensionManifestReadException;
import org.zowe.apiml.extension.ZoweRuntimeEnvironment;

public class ExtensionConfigReader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExtensionConfigReader.class);
    private final ZoweRuntimeEnvironment environment;

    public ExtensionConfigReader(ZoweRuntimeEnvironment environment) {
        this.environment = environment;
    }

    public String[] getBasePackages() {
        return this.getEnabledExtensions().stream().map(ExtensionDefinition::getApimlServices).filter(Objects::nonNull).map(ExtensionDefinition.ApimlServices::getBasePackage).filter(Objects::nonNull).collect(Collectors.toList()).toArray(new String[0]);
    }

    private List<ExtensionDefinition> getEnabledExtensions() {
        List<String> installedComponents = this.environment.getInstalledComponents();
        List<String> enabledComponents = this.environment.getEnabledComponents();
        ArrayList<ExtensionDefinition> extensions = new ArrayList<ExtensionDefinition>();
        for (String installedComponent : installedComponents) {
            if (!enabledComponents.contains(installedComponent)) continue;
            try {
                extensions.add(this.readComponentManifest(installedComponent));
            }
            catch (ExtensionManifestReadException e) {
                log.error("Failed reading component {} manifest", (Object)installedComponent, (Object)e);
            }
        }
        return extensions;
    }

    private ExtensionDefinition readComponentManifest(String installedComponent) {
        String parentPath = this.environment.getWorkspaceDirectory() + File.separator + installedComponent;
        Path manifestYamlPath = Paths.get(parentPath + File.separator + "manifest.yaml", new String[0]);
        Path manifestJsonPath = Paths.get(parentPath + File.separator + "manifest.json", new String[0]);
        Optional<ExtensionDefinition> definition = this.readComponentManifestWithCharset(Charset.defaultCharset(), manifestYamlPath, manifestJsonPath);
        if (definition.isPresent()) {
            return definition.get();
        }
        return this.readComponentManifestWithCharset(Charset.forName("IBM1047"), manifestYamlPath, manifestJsonPath).orElseThrow(() -> new ExtensionManifestReadException("Could not read manifest in either " + Charset.defaultCharset() + " nor in IBM1047 encoding"));
    }

    private Optional<ExtensionDefinition> readComponentManifestWithCharset(Charset charset, Path yamlPath, Path jsonPath) {
        ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ObjectMapper jsonMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            if (Files.exists(yamlPath, new LinkOption[0])) {
                return Optional.ofNullable((ExtensionDefinition)yamlMapper.readValue(new String(Files.readAllBytes(yamlPath), charset), ExtensionDefinition.class));
            }
            if (Files.exists(jsonPath, new LinkOption[0])) {
                return Optional.ofNullable((ExtensionDefinition)jsonMapper.readValue(new String(Files.readAllBytes(jsonPath), charset), ExtensionDefinition.class));
            }
            log.debug("None of these files were found: {} nor {} ", (Object)yamlPath, (Object)jsonPath);
            return Optional.empty();
        }
        catch (Exception e) {
            log.debug("File {}/{} does not have charset {}: {}", new Object[]{yamlPath, jsonPath, charset, e.getMessage()});
            return Optional.empty();
        }
    }
}

