/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.extension;

import java.util.Arrays;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.context.event.ApplicationContextInitializedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.zowe.apiml.extension.ExtensionConfigReader;

public class ExtensionsLoader
implements ApplicationListener<ApplicationContextInitializedEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExtensionsLoader.class);
    @NonNull
    private final ExtensionConfigReader configReader;

    public void onApplicationEvent(ApplicationContextInitializedEvent event) {
        if (!(event.getApplicationContext() instanceof BeanDefinitionRegistry)) {
            log.error("Expected Spring context to be a BeanDefinitionRegistry. Extensions are not loaded");
        } else {
            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)event.getApplicationContext();
            ClassPathBeanDefinitionScanner scanner = new ClassPathBeanDefinitionScanner(registry);
            Object[] extensionsBasePackages = this.configReader.getBasePackages();
            log.info("Loading extensions defined in {} packages", (Object)Arrays.toString(extensionsBasePackages));
            if (extensionsBasePackages.length > 0) {
                try {
                    String[] beanNames;
                    scanner.scan(this.configReader.getBasePackages());
                    for (String name : beanNames = scanner.getRegistry().getBeanDefinitionNames()) {
                        if (!registry.containsBeanDefinition(name)) {
                            registry.registerBeanDefinition(name, scanner.getRegistry().getBeanDefinition(name));
                            continue;
                        }
                        log.info("Bean with name " + name + " is already registered in the context");
                    }
                }
                catch (Exception e) {
                    log.error("Failed loading extensions", (Throwable)e);
                }
            }
        }
    }

    @Generated
    public ExtensionsLoader(@NonNull ExtensionConfigReader configReader) {
        if (configReader == null) {
            throw new NullPointerException("configReader is marked non-null but is null");
        }
        this.configReader = configReader;
    }
}

