/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.product.routing.transform;

import java.net.URI;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.zowe.apiml.message.log.ApimlLogger;
import org.zowe.apiml.product.gateway.GatewayClient;
import org.zowe.apiml.product.instance.ServiceAddress;
import org.zowe.apiml.product.logging.annotations.InjectApimlLogger;
import org.zowe.apiml.product.routing.RoutedService;
import org.zowe.apiml.product.routing.RoutedServices;
import org.zowe.apiml.product.routing.ServiceType;
import org.zowe.apiml.product.routing.transform.URLTransformationException;
import org.zowe.apiml.util.UrlUtils;

public class TransformService {
    private static final String SEPARATOR = "/";
    private final GatewayClient gatewayClient;
    @InjectApimlLogger
    private ApimlLogger apimlLog = ApimlLogger.empty();

    public String transformURL(ServiceType type, String serviceId, String serviceUrl, RoutedServices routes, boolean httpsScheme) throws URLTransformationException {
        if (!this.gatewayClient.isInitialized()) {
            this.apimlLog.log("org.zowe.apiml.common.gatewayNotFoundForTransformRequest", new Object[0]);
            throw new URLTransformationException("Gateway not found yet, transform service cannot perform the request");
        }
        URI serviceUri = URI.create(serviceUrl);
        Object serviceUriPath = serviceUri.getRawPath();
        if (serviceUriPath == null) {
            String message = String.format("The URI %s is not valid.", serviceUri);
            throw new URLTransformationException(message);
        }
        RoutedService route = routes.getBestMatchingServiceUrl((String)serviceUriPath, type);
        if (route == null) {
            String message = String.format("Not able to select route for url %s of the service %s. Original url used.", serviceUri, serviceId);
            throw new URLTransformationException(message);
        }
        if (StringUtils.isNotBlank((CharSequence)serviceUri.getRawQuery())) {
            serviceUriPath = (String)serviceUriPath + "?" + serviceUri.getRawQuery();
        }
        return this.transformURL(serviceId, (String)serviceUriPath, route, httpsScheme, serviceUri);
    }

    private String transformURL(String serviceId, String serviceUriPath, RoutedService route, boolean httpsScheme, URI originalUri) throws URLTransformationException {
        String endPoint = this.getShortEndpoint(route.getServiceUrl(), serviceUriPath);
        if (!endPoint.isEmpty() && !endPoint.startsWith(SEPARATOR)) {
            throw new URLTransformationException("The path " + originalUri.getPath() + " of the service URL " + String.valueOf(originalUri) + " is not valid.");
        }
        ServiceAddress gatewayConfigProperties = this.gatewayClient.getGatewayConfigProperties();
        if (originalUri != null && originalUri.toString().startsWith("//")) {
            return String.format("//%s/%s%s%s", gatewayConfigProperties.getHostname(), serviceId, StringUtils.isEmpty((CharSequence)route.getGatewayUrl()) ? "" : SEPARATOR + route.getGatewayUrl(), endPoint);
        }
        String scheme = httpsScheme ? "https" : gatewayConfigProperties.getScheme();
        return String.format("%s://%s/%s%s%s", scheme, gatewayConfigProperties.getHostname(), serviceId, StringUtils.isEmpty((CharSequence)route.getGatewayUrl()) ? "" : SEPARATOR + route.getGatewayUrl(), endPoint);
    }

    public String transformAbsoluteURL(String serviceId, String locationUri, RoutedService route) throws URLTransformationException {
        String endpoint = this.getShortEndpoint(route.getServiceUrl(), locationUri);
        if (this.isRelative(endpoint)) {
            throw new URLTransformationException("The path " + locationUri + " of the service " + serviceId + " is not valid.");
        }
        return String.format("/%s%s%s", serviceId, StringUtils.isEmpty((CharSequence)route.getGatewayUrl()) ? "" : SEPARATOR + route.getGatewayUrl(), endpoint);
    }

    boolean isRelative(String endpoint) {
        return !endpoint.isEmpty() && !endpoint.startsWith(SEPARATOR);
    }

    public String retrieveApiBasePath(String serviceId, String serviceUrl, RoutedServices routes) throws URLTransformationException {
        URI serviceUri = URI.create(serviceUrl = serviceUrl.trim());
        String serviceUriPath = serviceUri.getPath();
        if (serviceUriPath == null) {
            String message = String.format("The URI %s is not valid.", serviceUri);
            throw new URLTransformationException(message);
        }
        RoutedService route = routes.getBestMatchingApiUrl(serviceUriPath);
        if (route == null) {
            String message = String.format("Not able to select API base path for the service %s. Original url used.", serviceId);
            throw new URLTransformationException(message);
        }
        String templatedVersionRoute = route.getGatewayUrl().replaceAll("/v\\d+", "/{api-version}");
        return String.format("/%s/%s", serviceId, templatedVersionRoute);
    }

    private String getShortEndpoint(String routeServiceUrl, String endPoint) {
        String shortEndPoint = endPoint;
        if (!SEPARATOR.equals(routeServiceUrl) && StringUtils.isNotBlank((CharSequence)routeServiceUrl)) {
            shortEndPoint = shortEndPoint.replaceFirst(UrlUtils.removeLastSlash((String)routeServiceUrl), "");
        }
        return shortEndPoint;
    }

    @Generated
    public TransformService(GatewayClient gatewayClient) {
        this.gatewayClient = gatewayClient;
    }
}

