/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.product.version;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ResourceUtils;
import org.zowe.apiml.product.version.BuildInfo;
import org.zowe.apiml.product.version.BuildInfoDetails;
import org.zowe.apiml.product.version.VersionInfo;
import org.zowe.apiml.product.version.VersionInfoDetails;

@Service
public class VersionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VersionService.class);
    private final VersionInfo version;
    private final BuildInfo buildInfo;
    @Value(value="${apiml.zoweManifest:#{null}}")
    private String zoweManifest;
    @Value(value="${apiml.zoweManifestEncoding:IBM1047}")
    private String zoweManifestEncoding;

    public VersionService() {
        this.buildInfo = new BuildInfo();
        this.version = new VersionInfo();
    }

    public VersionService(BuildInfo buildInfo) {
        this.buildInfo = buildInfo;
        this.version = new VersionInfo();
    }

    public VersionInfo getVersion() {
        if (this.version.getApiml() == null) {
            this.updateVersionInfo();
        }
        return this.version;
    }

    public void updateVersionInfo() {
        if (StringUtils.isNotEmpty((CharSequence)this.zoweManifest)) {
            this.version.setZowe(this.getZoweVersion(this.zoweManifest));
        }
        this.version.setApiml(this.getApimlVersion());
    }

    private VersionInfoDetails getApimlVersion() {
        BuildInfoDetails buildInfoDetails = this.buildInfo.getBuildInfoDetails();
        return new VersionInfoDetails(buildInfoDetails.getVersion(), buildInfoDetails.getNumber(), buildInfoDetails.getCommitId());
    }

    private VersionInfoDetails getZoweVersion(String manifestJsonFile) {
        try {
            File file = ResourceUtils.getFile((String)manifestJsonFile);
            return this.readManifestJson(Files.readAllBytes(file.toPath()));
        }
        catch (IOException e) {
            log.debug("Error in reading the file {}: {}", (Object)manifestJsonFile, (Object)e.getMessage());
            return null;
        }
    }

    private VersionInfoDetails readManifestJson(byte[] jsonInBytes) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        String manifestJson = new String(jsonInBytes);
        try {
            return this.retrieveZoweVersion(manifestJson, mapper);
        }
        catch (JsonProcessingException e) {
            try {
                manifestJson = new String(jsonInBytes, Charset.forName(this.zoweManifestEncoding));
                return this.retrieveZoweVersion(manifestJson, mapper);
            }
            catch (JsonProcessingException ex) {
                log.debug("Error in parsing Zowe build manifest.json file: {}", (Object)e.getMessage());
                return null;
            }
        }
    }

    private VersionInfoDetails retrieveZoweVersion(String manifestJson, ObjectMapper mapper) throws JsonProcessingException {
        VersionInfoDetails zoweVersion = new VersionInfoDetails();
        ObjectNode manifestNode = (ObjectNode)mapper.readValue(manifestJson, ObjectNode.class);
        JsonNode versionNode = manifestNode.get("version");
        if (versionNode != null && !versionNode.asText().isEmpty()) {
            zoweVersion.setVersion(versionNode.asText());
        } else {
            zoweVersion.setVersion("Unknown");
        }
        this.retrieveZoweBuildNumber(manifestNode, zoweVersion);
        return zoweVersion;
    }

    private void retrieveZoweBuildNumber(ObjectNode manifestNode, VersionInfoDetails zoweVersion) {
        String buildNumber = "null";
        String commitHash = "Unknown";
        JsonNode buildNode = manifestNode.get("build");
        if (buildNode != null) {
            JsonNode commitIdNode;
            JsonNode buildNumberNode = buildNode.get("number");
            if (buildNumberNode != null && StringUtils.isNotEmpty((CharSequence)buildNumberNode.asText())) {
                buildNumber = buildNumberNode.asText();
            }
            if ((commitIdNode = buildNode.get("commitHash")) != null && StringUtils.isNotEmpty((CharSequence)commitIdNode.asText())) {
                commitHash = commitIdNode.asText();
            }
        }
        zoweVersion.setBuildNumber(buildNumber);
        zoweVersion.setCommitHash(commitHash);
    }
}

