/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.product.web;

import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.netflix.eureka.http.EurekaClientHttpRequestFactorySupplier;
import org.springframework.cloud.netflix.eureka.http.RestClientDiscoveryClientOptionalArgs;
import org.springframework.cloud.netflix.eureka.http.RestClientTransportClientFactories;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestClient;
import org.zowe.apiml.message.core.MessageService;
import org.zowe.apiml.message.log.ApimlLogger;
import org.zowe.apiml.message.yaml.YamlMessageServiceInstance;

@Configuration
public class DiscoveryRestTemplateConfig {
    private static final ApimlLogger apimlLog = ApimlLogger.of(DiscoveryRestTemplateConfig.class, (MessageService)YamlMessageServiceInstance.getInstance());
    @Value(value="${server.attlsClient.enabled:false}")
    private boolean isClientAttlsEnabled;
    private static final int CONNECT_TIMEOUT = 180000;
    private static final int REQUEST_TIMEOUT = 180000;
    private static final int SOCKET_TIMEOUT = 180000;
    private static final int IDLE_TIMEOUT = 60;

    @Bean
    RestClientTransportClientFactories restTemplateTransportClientFactories(RestClientDiscoveryClientOptionalArgs restClientDiscoveryClientOptionalArgs) {
        return new RestClientTransportClientFactories(restClientDiscoveryClientOptionalArgs);
    }

    @Bean
    RestClientDiscoveryClientOptionalArgs defaultArgs(@Value(value="${eureka.client.serviceUrl.defaultZone}") String eurekaServerUrl, @Qualifier(value="secureSslContext") SSLContext secureSslContext, HostnameVerifier secureHostnameVerifier) {
        RestClientDiscoveryClientOptionalArgs clientArgs = new RestClientDiscoveryClientOptionalArgs(DiscoveryRestTemplateConfig.getDefaultEurekaClientHttpRequestFactorySupplier(), RestClient::builder);
        if (eurekaServerUrl.startsWith("http://")) {
            if (!this.isClientAttlsEnabled) {
                apimlLog.log("org.zowe.apiml.common.insecureHttpWarning", new Object[0]);
            }
        } else {
            clientArgs.setSSLContext(secureSslContext);
            clientArgs.setHostnameVerifier(secureHostnameVerifier);
        }
        return clientArgs;
    }

    public static EurekaClientHttpRequestFactorySupplier getDefaultEurekaClientHttpRequestFactorySupplier() {
        return (sslContext, hostnameVerifier) -> {
            HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
            HttpClientBuilder httpClientBuilder = HttpClients.custom().evictExpiredConnections().evictIdleConnections(TimeValue.ofSeconds((long)60L)).setConnectionManager(DiscoveryRestTemplateConfig.buildConnectionManager(sslContext, hostnameVerifier));
            RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
            requestConfigBuilder.setConnectionRequestTimeout(Timeout.of((long)180000L, (TimeUnit)TimeUnit.MILLISECONDS));
            httpClientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
            CloseableHttpClient httpClient = httpClientBuilder.build();
            requestFactory.setHttpClient((HttpClient)httpClient);
            return requestFactory;
        };
    }

    private static HttpClientConnectionManager buildConnectionManager(SSLContext sslContext, HostnameVerifier hostnameVerifier) {
        PoolingHttpClientConnectionManagerBuilder connectionManagerBuilder = PoolingHttpClientConnectionManagerBuilder.create();
        connectionManagerBuilder.setTlsSocketStrategy((TlsSocketStrategy)new DefaultClientTlsStrategy(sslContext, hostnameVerifier));
        connectionManagerBuilder.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(Timeout.of((long)180000L, (TimeUnit)TimeUnit.MILLISECONDS)).build());
        connectionManagerBuilder.setDefaultConnectionConfig(ConnectionConfig.custom().setConnectTimeout(Timeout.of((long)180000L, (TimeUnit)TimeUnit.MILLISECONDS)).build());
        return connectionManagerBuilder.build();
    }
}

