/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.product.web;

import jakarta.annotation.PostConstruct;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;
import org.zowe.apiml.security.ApimlPoolingHttpClientConnectionManager;
import org.zowe.apiml.security.HttpsConfig;
import org.zowe.apiml.security.HttpsConfigError;
import org.zowe.apiml.security.HttpsFactory;
import org.zowe.apiml.security.SecurityUtils;

@Configuration
public class HttpConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpConfig.class);
    private static final char[] KEYRING_PASSWORD = "password".toCharArray();
    @Value(value="${server.ssl.protocol:TLSv1.2}")
    private String protocol;
    @Value(value="${apiml.httpclient.ssl.enabled-protocols:TLSv1.2,TLSv1.3}")
    private String[] supportedProtocols;
    @Value(value="${server.ssl.ciphers:TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384,TLS_AES_128_GCM_SHA256,TLS_AES_256_GCM_SHA384}")
    private String[] ciphers;
    @Value(value="${server.ssl.trustStore:#{null}}")
    private String trustStore;
    @Value(value="${server.ssl.trustStorePassword:#{null}}")
    private char[] trustStorePassword;
    @Value(value="${server.ssl.trustStoreType:PKCS12}")
    private String trustStoreType;
    @Value(value="${server.ssl.keyAlias:#{null}}")
    private String keyAlias;
    @Value(value="${server.ssl.keyStore:#{null}}")
    private String keyStorePath;
    @Value(value="${server.ssl.keyStorePassword:#{null}}")
    private char[] keyStorePassword;
    @Value(value="${server.ssl.keyPassword:#{null}}")
    private char[] keyPassword;
    @Value(value="${server.ssl.keyStoreType:PKCS12}")
    private String keyStoreType;
    @Value(value="${apiml.security.ssl.verifySslCertificatesOfServices:true}")
    private boolean verifySslCertificatesOfServices;
    @Value(value="${apiml.security.ssl.nonStrictVerifySslCertificatesOfServices:false}")
    private boolean nonStrictVerifySslCertificatesOfServices;
    @Value(value="${server.ssl.trustStoreRequired:false}")
    private boolean trustStoreRequired;
    @Value(value="${server.maxConnectionsPerRoute:#{10}}")
    private Integer maxConnectionsPerRoute;
    @Value(value="${server.maxTotalConnections:#{100}}")
    private Integer maxTotalConnections;
    @Value(value="${apiml.connection.idleConnectionTimeoutSeconds:#{5}}")
    private int idleConnTimeoutSeconds;
    @Value(value="${apiml.connection.timeout:#{60000}}")
    private int requestConnectionTimeout;
    @Value(value="${apiml.connection.timeToLive:#{60000}}")
    private int timeToLive;
    private final Timer connectionManagerTimer = new Timer("ApimlHttpClientConfiguration.connectionManagerTimer", true);
    private CloseableHttpClient secureHttpClient;
    private CloseableHttpClient secureHttpClientWithoutKeystore;
    private HttpsConfig httpsConfig;
    private SSLContext secureSslContext;
    private SSLContext secureSslContextWithoutKeystore;
    private HostnameVerifier secureHostnameVerifier;
    private Set<String> publicKeyCertificatesBase64;

    void updateStorePaths() {
        if (SecurityUtils.isKeyring((String)this.keyStorePath)) {
            this.keyStorePath = SecurityUtils.formatKeyringUrl((String)this.keyStorePath);
            if (this.keyStorePassword == null) {
                this.keyStorePassword = KEYRING_PASSWORD;
            }
        }
        if (SecurityUtils.isKeyring((String)this.trustStore)) {
            this.trustStore = SecurityUtils.formatKeyringUrl((String)this.trustStore);
            if (this.trustStorePassword == null) {
                this.trustStorePassword = KEYRING_PASSWORD;
            }
        }
    }

    @PostConstruct
    public void init() {
        this.updateStorePaths();
        try {
            X509Certificate certificate = null;
            if (StringUtils.isNotBlank((CharSequence)this.keyStorePath)) {
                KeyStore ks = SecurityUtils.loadKeyStore((String)this.keyStoreType, (String)this.keyStorePath, (char[])this.keyStorePassword);
                certificate = (X509Certificate)ks.getCertificate(this.keyAlias);
            }
            Supplier<HttpsConfig.HttpsConfigBuilder> httpsConfigSupplier = () -> HttpsConfig.builder().protocol(this.protocol).enabledProtocols(this.supportedProtocols).cipherSuite(this.ciphers).trustStore(this.trustStore).trustStoreType(this.trustStoreType).trustStorePassword(this.trustStorePassword).trustStoreRequired(this.trustStoreRequired).verifySslCertificatesOfServices(this.verifySslCertificatesOfServices).nonStrictVerifySslCertificatesOfServices(this.nonStrictVerifySslCertificatesOfServices).maxConnectionsPerRoute(this.maxConnectionsPerRoute.intValue()).maxTotalConnections(this.maxTotalConnections.intValue()).idleConnTimeoutSeconds(this.idleConnTimeoutSeconds).requestConnectionTimeout(this.requestConnectionTimeout).timeToLive(this.timeToLive);
            this.httpsConfig = httpsConfigSupplier.get().keyAlias(this.keyAlias).keyStore(this.keyStorePath).keyPassword(this.keyPassword).keyStorePassword(this.keyStorePassword).keyStoreType(this.keyStoreType).certificate(certificate).build();
            HttpsConfig httpsConfigWithoutKeystore = httpsConfigSupplier.get().build();
            log.info("Using HTTPS configuration: {}", (Object)this.httpsConfig.toString());
            HttpsFactory factory = new HttpsFactory(this.httpsConfig);
            ApimlPoolingHttpClientConnectionManager secureConnectionManager = this.getConnectionManager(factory);
            this.secureHttpClient = factory.buildHttpClient((HttpClientConnectionManager)secureConnectionManager);
            this.secureSslContext = factory.getSslContext();
            this.secureHostnameVerifier = factory.getHostnameVerifier();
            HttpsFactory factoryWithoutKeystore = new HttpsFactory(httpsConfigWithoutKeystore);
            ApimlPoolingHttpClientConnectionManager connectionManagerWithoutKeystore = this.getConnectionManager(factoryWithoutKeystore);
            this.secureHttpClientWithoutKeystore = factoryWithoutKeystore.buildHttpClient((HttpClientConnectionManager)connectionManagerWithoutKeystore);
            this.secureSslContextWithoutKeystore = factoryWithoutKeystore.getSslContext();
            this.publicKeyCertificatesBase64 = SecurityUtils.loadCertificateChainBase64((HttpsConfig)this.httpsConfig);
        }
        catch (HttpsConfigError e) {
            log.error("Invalid configuration of HTTPs: {}", (Object)e.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            log.error("Cannot construct configuration of HTTPs: {}", (Object)e.getMessage());
            System.exit(1);
        }
    }

    public ApimlPoolingHttpClientConnectionManager getConnectionManager(HttpsFactory factory) {
        RegistryBuilder socketFactoryRegistryBuilder = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
        socketFactoryRegistryBuilder.register("https", (Object)factory.createSslSocketFactory());
        Registry socketFactoryRegistry = socketFactoryRegistryBuilder.build();
        final ApimlPoolingHttpClientConnectionManager connectionManager = new ApimlPoolingHttpClientConnectionManager(socketFactoryRegistry, this.timeToLive);
        ConnectionConfig connConfig = ConnectionConfig.custom().setConnectTimeout(Timeout.ofMilliseconds((long)this.requestConnectionTimeout)).setSocketTimeout(Timeout.ofMilliseconds((long)this.requestConnectionTimeout)).setTimeToLive((TimeValue)Timeout.ofMilliseconds((long)this.timeToLive)).build();
        this.connectionManagerTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                connectionManager.closeExpired();
                connectionManager.closeIdle((TimeValue)Timeout.ofSeconds((long)HttpConfig.this.idleConnTimeoutSeconds));
            }
        }, 30000L, 30000L);
        connectionManager.setDefaultConnectionConfig(connConfig);
        connectionManager.setDefaultMaxPerRoute(this.maxConnectionsPerRoute.intValue());
        connectionManager.setMaxTotal(this.maxTotalConnections.intValue());
        return connectionManager;
    }

    @Bean
    public Set<String> publicKeyCertificatesBase64() {
        return this.publicKeyCertificatesBase64;
    }

    @Bean
    @Primary
    public RestTemplate restTemplateWithKeystore() {
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory((HttpClient)this.secureHttpClient);
        factory.setConnectionRequestTimeout(this.requestConnectionTimeout);
        factory.setConnectTimeout(this.requestConnectionTimeout);
        return new RestTemplate((ClientHttpRequestFactory)factory);
    }

    @Bean
    public RestTemplate restTemplateWithoutKeystore() {
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory((HttpClient)this.secureHttpClientWithoutKeystore);
        factory.setConnectionRequestTimeout(this.requestConnectionTimeout);
        factory.setConnectTimeout(this.requestConnectionTimeout);
        return new RestTemplate((ClientHttpRequestFactory)factory);
    }

    @Bean(value={"secureHttpClientWithKeystore"})
    @Primary
    public CloseableHttpClient secureHttpClient() {
        return this.secureHttpClient;
    }

    @Bean
    public CloseableHttpClient secureHttpClientWithoutKeystore() {
        return this.secureHttpClientWithoutKeystore;
    }

    @Bean
    public SSLContext secureSslContext() {
        return this.secureSslContext;
    }

    @Bean
    public SSLContext secureSslContextWithoutKeystore() {
        return this.secureSslContextWithoutKeystore;
    }

    @Bean
    public HostnameVerifier secureHostnameVerifier() {
        return this.secureHostnameVerifier;
    }

    @Generated
    public HttpsConfig getHttpsConfig() {
        return this.httpsConfig;
    }

    @Generated
    public SSLContext getSecureSslContext() {
        return this.secureSslContext;
    }

    @Generated
    public SSLContext getSecureSslContextWithoutKeystore() {
        return this.secureSslContextWithoutKeystore;
    }

    @Generated
    public HostnameVerifier getSecureHostnameVerifier() {
        return this.secureHostnameVerifier;
    }
}

