/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.product.web;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.netflix.eureka.RestClientTimeoutProperties;
import org.springframework.cloud.netflix.eureka.TimeoutProperties;
import org.springframework.cloud.netflix.eureka.http.DefaultEurekaClientHttpRequestFactorySupplier;
import org.springframework.cloud.netflix.eureka.http.EurekaClientHttpRequestFactorySupplier;
import org.springframework.cloud.netflix.eureka.http.RestClientDiscoveryClientOptionalArgs;
import org.springframework.cloud.netflix.eureka.http.RestClientTransportClientFactories;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestClient;
import org.zowe.apiml.message.core.MessageService;
import org.zowe.apiml.message.log.ApimlLogger;
import org.zowe.apiml.message.yaml.YamlMessageServiceInstance;

@Configuration
public class DiscoveryRestTemplateConfig {
    private static final ApimlLogger apimlLog = ApimlLogger.of(DiscoveryRestTemplateConfig.class, (MessageService)YamlMessageServiceInstance.getInstance());

    @Bean
    public RestClientTransportClientFactories restTemplateTransportClientFactories(RestClientDiscoveryClientOptionalArgs restClientDiscoveryClientOptionalArgs) {
        return new RestClientTransportClientFactories(restClientDiscoveryClientOptionalArgs);
    }

    @Bean
    public RestClientDiscoveryClientOptionalArgs defaultArgs(@Value(value="${eureka.client.serviceUrl.defaultZone}") String eurekaServerUrl, @Qualifier(value="secureSslContext") SSLContext secureSslContext, HostnameVerifier secureHostnameVerifier) {
        RestClientDiscoveryClientOptionalArgs clientArgs = new RestClientDiscoveryClientOptionalArgs((EurekaClientHttpRequestFactorySupplier)DiscoveryRestTemplateConfig.getDefaultEurekaClientHttpRequestFactorySupplier(), RestClient::builder);
        if (eurekaServerUrl.startsWith("http://")) {
            apimlLog.log("org.zowe.apiml.common.insecureHttpWarning", new Object[0]);
        } else {
            clientArgs.setSSLContext(secureSslContext);
            clientArgs.setHostnameVerifier(secureHostnameVerifier);
        }
        return clientArgs;
    }

    private static DefaultEurekaClientHttpRequestFactorySupplier getDefaultEurekaClientHttpRequestFactorySupplier() {
        RestClientTimeoutProperties properties = new RestClientTimeoutProperties();
        properties.setConnectTimeout(180000);
        properties.setConnectRequestTimeout(180000);
        properties.setSocketTimeout(180000);
        return new DefaultEurekaClientHttpRequestFactorySupplier((TimeoutProperties)properties);
    }
}

