/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.util.config;

import io.restassured.config.RestAssuredConfig;
import io.restassured.config.SSLConfig;
import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;
import org.zowe.apiml.util.config.SslContextConfigurer;

public class SslContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SslContext.class);
    public static RestAssuredConfig clientCertValid;
    public static RestAssuredConfig clientCertApiml;
    public static RestAssuredConfig clientCertUser;
    public static RestAssuredConfig clientCertUnknownUser;
    public static RestAssuredConfig apimlRootCert;
    public static RestAssuredConfig selfSignedUntrusted;
    public static RestAssuredConfig tlsWithoutCert;
    private static AtomicBoolean isInitialized;
    private static AtomicReference<SslContextConfigurer> configurer;

    public static synchronized void reset() {
        clientCertValid = null;
        clientCertApiml = null;
        clientCertUser = null;
        clientCertUnknownUser = null;
        apimlRootCert = null;
        selfSignedUntrusted = null;
        tlsWithoutCert = null;
        configurer.set(null);
        isInitialized.set(false);
    }

    public static synchronized void prepareSslAuthentication(SslContextConfigurer providedConfigurer) throws Exception {
        if (configurer.get() != null && !configurer.get().equals(providedConfigurer)) {
            throw new IllegalStateException("You cannot initialize this class twice with different configuration");
        }
        if (!isInitialized.get()) {
            configurer.set(providedConfigurer);
            X509HostnameVerifier hostnameVerifier = providedConfigurer.getHostnameVerifier();
            log.info("SSLContext is constructing. This should happen only once.");
            TrustStrategy trustStrategy = (chain, authType) -> true;
            SSLContext sslContext = SSLContextBuilder.create().loadKeyMaterial(ResourceUtils.getFile((String)providedConfigurer.getKeystoreLocalhostJks()), providedConfigurer.getKeystorePassword(), providedConfigurer.getKeystorePassword(), (aliases, socket) -> "apimtst").loadTrustMaterial(null, trustStrategy).build();
            clientCertValid = RestAssuredConfig.newConfig().sslConfig(new SSLConfig().sslSocketFactory(new SSLSocketFactory(sslContext, hostnameVerifier)));
            log.debug("Loaded {}[apimtst]", (Object)providedConfigurer.getKeystoreLocalhostJks());
            SSLContext sslContext2 = SSLContextBuilder.create().loadKeyMaterial(ResourceUtils.getFile((String)providedConfigurer.getKeystore()), providedConfigurer.getKeystorePassword(), providedConfigurer.getKeystorePassword()).loadTrustMaterial(null, trustStrategy).build();
            clientCertApiml = RestAssuredConfig.newConfig().sslConfig(new SSLConfig().sslSocketFactory(new SSLSocketFactory(sslContext2, hostnameVerifier)));
            log.debug("Loaded {}", (Object)providedConfigurer.getKeystore());
            SSLContext sslContext3 = SSLContextBuilder.create().loadTrustMaterial(null, trustStrategy).build();
            tlsWithoutCert = RestAssuredConfig.newConfig().sslConfig(new SSLConfig().sslSocketFactory(new SSLSocketFactory(sslContext3, hostnameVerifier)));
            log.debug("Loaded truststore without certs");
            SSLContext sslContext4 = SSLContextBuilder.create().loadKeyMaterial(ResourceUtils.getFile((String)providedConfigurer.getKeystoreLocalhostJks()), providedConfigurer.getKeystorePassword(), providedConfigurer.getKeystorePassword(), (aliases, socket) -> "unknownuser").loadTrustMaterial(null, trustStrategy).build();
            clientCertUnknownUser = RestAssuredConfig.newConfig().sslConfig(new SSLConfig().sslSocketFactory(new SSLSocketFactory(sslContext4, hostnameVerifier)));
            log.debug("Loaded {}[unknownuser]", (Object)providedConfigurer.getKeystoreLocalhostJks());
            SSLContext sslContext5 = SSLContextBuilder.create().loadKeyMaterial(ResourceUtils.getFile((String)providedConfigurer.getKeystoreLocalhostJks()), providedConfigurer.getKeystorePassword(), providedConfigurer.getKeystorePassword(), (aliases, socket) -> "user").loadTrustMaterial(null, trustStrategy).build();
            clientCertUser = RestAssuredConfig.newConfig().sslConfig(new SSLConfig().sslSocketFactory(new SSLSocketFactory(sslContext5, hostnameVerifier)));
            log.debug("Loaded {}[user]", (Object)providedConfigurer.getKeystoreLocalhostJks());
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            String cert = "-----BEGIN CERTIFICATE-----\nMIIEFTCCAv2gAwIBAgIEKWdbVTANBgkqhkiG9w0BAQsFADCBjDELMAkGA1UEBhMC\nQ1oxDTALBgNVBAgTBEJybm8xDTALBgNVBAcTBEJybm8xFDASBgNVBAoTC1pvd2Ug\nU2FtcGxlMRwwGgYDVQQLExNBUEkgTWVkaWF0aW9uIExheWVyMSswKQYDVQQDEyJa\nb3dlIFNlbGYtU2lnbmVkIFVudHJ1c3RlZCBTZXJ2aWNlMB4XDTE4MTIwNzIwMDc1\nMloXDTI4MTIwNDIwMDc1MlowgYwxCzAJBgNVBAYTAkNaMQ0wCwYDVQQIEwRCcm5v\nMQ0wCwYDVQQHEwRCcm5vMRQwEgYDVQQKEwtab3dlIFNhbXBsZTEcMBoGA1UECxMT\nQVBJIE1lZGlhdGlvbiBMYXllcjErMCkGA1UEAxMiWm93ZSBTZWxmLVNpZ25lZCBV\nbnRydXN0ZWQgU2VydmljZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEB\nAJti8p4nr8ztRSbemrAv1ytVLQMbXozhLe3lNaiVADGTFPZYeJ2lDt7oAl238HOY\nScpOz+JjTeUkL0jsjNYgMhi4J07II/3sJL0SBfVqvvgjUL4BvcpdBl0crSuI/3D4\nOaPue+ZmPFijwdCcw5JbazMoOka/zUwpYYdbwxPUH2BbKfwtmmygX88nkJcRSoQO\nKBdNsUs+QRuUiokZ/FJi7uiOsNZ8eEfQv6qJ7mOJ7l1IrMcNm3jHgodoQi/4jXO1\nnp/hZaz/ZDni9kBwcyd64AViB2v7VrrBmjdESt1mtCIMvKMlwAZAqrDO75Q9pepO\nY7zbN4s9s7IUfyb9431xg2MCAwEAAaN9MHswHQYDVR0lBBYwFAYIKwYBBQUHAwIG\nCCsGAQUFBwMBMA4GA1UdDwEB/wQEAwIE8DArBgNVHREEJDAighVsb2NhbGhvc3Qu\nbG9jYWxkb21haW6CCWxvY2FsaG9zdDAdBgNVHQ4EFgQUIeSN7aNtwH2MnBAGDLre\nTtcSaZ4wDQYJKoZIhvcNAQELBQADggEBAELPbHlG60nO164yrBjZcpQJ/2e5ThOR\n8efXUWExuy/NpwVx0vJg4tb8s9NI3X4pRh3WyD0uGPGkO9w+CAvgUaECePLYjkov\nKIS6Cvlcav9nWqdZau1fywltmOLu8Sq5i42Yvb7ZcPOEwDShpuq0ql7LR7j7P4XH\n+JkA0k9Zi6RfYJAyOOpbD2R4JoMbxBKrxUVs7cEajl2ltckjyRWoB6FBud1IthRR\nmZoPMtlCleKlsKp7yJiE13hpX+qIGnzEQE2gNgQ94dSl4m2xO6pnyDRMAEncmd33\noehy77omRxNsLzkWe6mjaC8ShMGzG9jYR02iN2h4083/PVXvTZIqwhg=\n-----END CERTIFICATE-----\n";
            ks.load(null);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream certStream = new ByteArrayInputStream(cert.getBytes());
            Certificate certificate = cf.generateCertificate(certStream);
            ks.setCertificateEntry("selfsigned", certificate);
            SSLContext sslContext6 = SSLContextBuilder.create().loadKeyMaterial(ks, "password".toCharArray()).loadTrustMaterial(null, trustStrategy).build();
            selfSignedUntrusted = RestAssuredConfig.newConfig().sslConfig(new SSLConfig().sslSocketFactory(new SSLSocketFactory(sslContext6, hostnameVerifier)));
            log.debug("Loaded Self-signed certificate untrusted");
            SSLContext sslContext7 = SSLContextBuilder.create().loadKeyMaterial(ResourceUtils.getFile((String)providedConfigurer.getKeystoreLocalhostJks()), providedConfigurer.getKeystorePassword(), providedConfigurer.getKeystorePassword(), (aliases, socket) -> "apiml external certificate authority").loadTrustMaterial(null, trustStrategy).build();
            apimlRootCert = RestAssuredConfig.newConfig().sslConfig(new SSLConfig().sslSocketFactory(new SSLSocketFactory(sslContext7, hostnameVerifier)));
            log.debug("Loaded API ML root");
            isInitialized.set(true);
        }
    }

    static {
        isInitialized = new AtomicBoolean(false);
        configurer = new AtomicReference();
    }
}

