/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.product.eureka.client;

import com.netflix.discovery.shared.transport.EurekaHttpResponse;
import com.netflix.eureka.registry.PeerAwareInstanceRegistryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReplicationTask {
    private static final Logger logger = LoggerFactory.getLogger(ReplicationTask.class);
    protected final String peerNodeName;
    protected final PeerAwareInstanceRegistryImpl.Action action;

    ReplicationTask(String peerNodeName, PeerAwareInstanceRegistryImpl.Action action) {
        this.peerNodeName = peerNodeName;
        this.action = action;
    }

    public abstract String getTaskName();

    public PeerAwareInstanceRegistryImpl.Action getAction() {
        return this.action;
    }

    public abstract EurekaHttpResponse<?> execute() throws Throwable;

    public void handleSuccess() {
    }

    public void handleFailure(int statusCode, Object responseEntity) throws Throwable {
        logger.warn("The replication of task {} failed with response code {}", (Object)this.getTaskName(), (Object)statusCode);
    }
}

