/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.product.instance.lookup;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.shared.Application;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zowe.apiml.constants.EurekaMetadataDefinition;
import org.zowe.apiml.product.instance.InstanceNotFoundException;
import org.zowe.apiml.product.instance.lookup.RetryException;

public class InstanceLookupExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstanceLookupExecutor.class);
    private final EurekaClient eurekaClient;

    private InstanceInfo findEurekaInstance(String serviceId) {
        Application application = this.eurekaClient.getApplication(serviceId);
        if (application == null) {
            throw new InstanceNotFoundException("Service '" + serviceId + "' is not registered to Discovery Service");
        }
        return application.getInstances().stream().filter(ii -> EurekaMetadataDefinition.RegistrationType.of((Map)ii.getMetadata()).isPrimary()).findFirst().orElseThrow(() -> new InstanceNotFoundException("'" + serviceId + "' has no running instances registered to Discovery Service"));
    }

    public void run(String serviceId, Consumer<InstanceInfo> action, BiConsumer<Exception, Boolean> handleFailureConsumer) {
        log.debug("Started instance finder");
        try {
            InstanceInfo instanceInfo = this.findEurekaInstance(serviceId);
            log.debug("App found {}", (Object)instanceInfo.getAppName());
            action.accept(instanceInfo);
        }
        catch (InstanceNotFoundException | RetryException e) {
            log.debug(e.getMessage());
            handleFailureConsumer.accept(e, false);
        }
        catch (Exception e) {
            handleFailureConsumer.accept(e, true);
            log.debug("Unexpected exception while retrieving '{}' service from Eureka", (Object)serviceId);
        }
    }

    @Generated
    public InstanceLookupExecutor(EurekaClient eurekaClient) {
        this.eurekaClient = eurekaClient;
    }
}

