/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.product.web;

import jakarta.annotation.PostConstruct;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;
import org.zowe.apiml.security.ApimlPoolingHttpClientConnectionManager;
import org.zowe.apiml.security.HttpsConfig;
import org.zowe.apiml.security.HttpsConfigError;
import org.zowe.apiml.security.HttpsFactory;
import org.zowe.apiml.security.SecurityUtils;

@Configuration
public class HttpConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpConfig.class);
    private static final char[] KEYRING_PASSWORD = "password".toCharArray();
    @Value(value="${server.ssl.protocol:TLSv1.2}")
    private String protocol;
    @Value(value="${apiml.httpclient.ssl.enabled-protocols:TLSv1.2,TLSv1.3}")
    private String[] supportedProtocols;
    @Value(value="${server.ssl.ciphers:TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384,TLS_AES_128_GCM_SHA256,TLS_AES_256_GCM_SHA384}")
    private String[] ciphers;
    @Value(value="${server.ssl.trustStore:#{null}}")
    private String trustStore;
    @Value(value="${server.ssl.trustStorePassword:#{null}}")
    private char[] trustStorePassword;
    @Value(value="${server.ssl.trustStoreType:PKCS12}")
    private String trustStoreType;
    @Value(value="${server.ssl.keyAlias:#{null}}")
    private String keyAlias;
    @Value(value="${server.ssl.keyStore:#{null}}")
    private String keyStore;
    @Value(value="${server.ssl.keyStorePassword:#{null}}")
    private char[] keyStorePassword;
    @Value(value="${server.ssl.keyPassword:#{null}}")
    private char[] keyPassword;
    @Value(value="${server.ssl.keyStoreType:PKCS12}")
    private String keyStoreType;
    @Value(value="${apiml.security.ssl.verifySslCertificatesOfServices:true}")
    private boolean verifySslCertificatesOfServices;
    @Value(value="${apiml.security.ssl.nonStrictVerifySslCertificatesOfServices:false}")
    private boolean nonStrictVerifySslCertificatesOfServices;
    @Value(value="${server.ssl.trustStoreRequired:false}")
    private boolean trustStoreRequired;
    @Value(value="${server.maxConnectionsPerRoute:#{10}}")
    private Integer maxConnectionsPerRoute;
    @Value(value="${server.maxTotalConnections:#{100}}")
    private Integer maxTotalConnections;
    @Value(value="${apiml.httpclient.conn-pool.idleConnTimeoutSeconds:#{5}}")
    private int idleConnTimeoutSeconds;
    @Value(value="${apiml.httpclient.conn-pool.requestConnectionTimeout:#{10000}}")
    private int requestConnectionTimeout;
    @Value(value="${apiml.httpclient.conn-pool.readTimeout:#{10000}}")
    private int readTimeout;
    @Value(value="${apiml.httpclient.conn-pool.timeToLive:#{10000}}")
    private int timeToLive;
    private final Timer connectionManagerTimer = new Timer("ApimlHttpClientConfiguration.connectionManagerTimer", true);
    private CloseableHttpClient secureHttpClient;
    private CloseableHttpClient secureHttpClientWithoutKeystore;
    private SSLContext secureSslContext;
    private HostnameVerifier secureHostnameVerifier;
    private Set<String> publicKeyCertificatesBase64;

    void updateStorePaths() {
        if (SecurityUtils.isKeyring((String)this.keyStore)) {
            this.keyStore = SecurityUtils.formatKeyringUrl((String)this.keyStore);
            if (this.keyStorePassword == null) {
                this.keyStorePassword = KEYRING_PASSWORD;
            }
        }
        if (SecurityUtils.isKeyring((String)this.trustStore)) {
            this.trustStore = SecurityUtils.formatKeyringUrl((String)this.trustStore);
            if (this.trustStorePassword == null) {
                this.trustStorePassword = KEYRING_PASSWORD;
            }
        }
    }

    @PostConstruct
    public void init() {
        this.updateStorePaths();
        try {
            Supplier<HttpsConfig.HttpsConfigBuilder> httpsConfigSupplier = () -> HttpsConfig.builder().protocol(this.protocol).enabledProtocols(this.supportedProtocols).cipherSuite(this.ciphers).trustStore(this.trustStore).trustStoreType(this.trustStoreType).trustStorePassword(this.trustStorePassword).trustStoreRequired(this.trustStoreRequired).verifySslCertificatesOfServices(this.verifySslCertificatesOfServices).nonStrictVerifySslCertificatesOfServices(this.nonStrictVerifySslCertificatesOfServices).maxConnectionsPerRoute(this.maxConnectionsPerRoute.intValue()).maxTotalConnections(this.maxTotalConnections.intValue()).idleConnTimeoutSeconds(this.idleConnTimeoutSeconds).requestConnectionTimeout(this.requestConnectionTimeout).timeToLive(this.timeToLive);
            HttpsConfig httpsConfig = httpsConfigSupplier.get().keyAlias(this.keyAlias).keyStore(this.keyStore).keyPassword(this.keyPassword).keyStorePassword(this.keyStorePassword).keyStoreType(this.keyStoreType).build();
            HttpsConfig httpsConfigWithoutKeystore = httpsConfigSupplier.get().build();
            log.info("Using HTTPS configuration: {}", (Object)httpsConfig.toString());
            HttpsFactory factory = new HttpsFactory(httpsConfig);
            ApimlPoolingHttpClientConnectionManager secureConnectionManager = this.getConnectionManager(factory);
            this.secureHttpClient = factory.buildHttpClient((HttpClientConnectionManager)secureConnectionManager);
            this.secureSslContext = factory.getSslContext();
            this.secureHostnameVerifier = factory.getHostnameVerifier();
            HttpsFactory factoryWithoutKeystore = new HttpsFactory(httpsConfigWithoutKeystore);
            ApimlPoolingHttpClientConnectionManager connectionManagerWithoutKeystore = this.getConnectionManager(factoryWithoutKeystore);
            this.secureHttpClientWithoutKeystore = factoryWithoutKeystore.buildHttpClient((HttpClientConnectionManager)connectionManagerWithoutKeystore);
            factory.setSystemSslProperties();
            this.publicKeyCertificatesBase64 = SecurityUtils.loadCertificateChainBase64((HttpsConfig)httpsConfig);
        }
        catch (HttpsConfigError e) {
            log.error("Invalid configuration of HTTPs: {}", (Object)e.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            log.error("Cannot construct configuration of HTTPs: {}", (Object)e.getMessage());
            System.exit(1);
        }
    }

    public ApimlPoolingHttpClientConnectionManager getConnectionManager(HttpsFactory factory) {
        RegistryBuilder socketFactoryRegistryBuilder = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
        socketFactoryRegistryBuilder.register("https", (Object)factory.createSslSocketFactory());
        Registry socketFactoryRegistry = socketFactoryRegistryBuilder.build();
        final ApimlPoolingHttpClientConnectionManager connectionManager = new ApimlPoolingHttpClientConnectionManager(socketFactoryRegistry, this.timeToLive);
        ConnectionConfig connConfig = ConnectionConfig.custom().setConnectTimeout(Timeout.ofMilliseconds((long)this.requestConnectionTimeout)).setSocketTimeout(Timeout.ofMilliseconds((long)this.requestConnectionTimeout)).setTimeToLive((TimeValue)Timeout.ofMilliseconds((long)this.timeToLive)).build();
        this.connectionManagerTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                connectionManager.closeExpired();
                connectionManager.closeIdle((TimeValue)Timeout.ofSeconds((long)HttpConfig.this.idleConnTimeoutSeconds));
            }
        }, 30000L, 30000L);
        connectionManager.setDefaultConnectionConfig(connConfig);
        connectionManager.setDefaultMaxPerRoute(this.maxConnectionsPerRoute.intValue());
        connectionManager.setMaxTotal(this.maxTotalConnections.intValue());
        return connectionManager;
    }

    @Bean
    @Qualifier(value="publicKeyCertificatesBase64")
    public Set<String> publicKeyCertificatesBase64() {
        return this.publicKeyCertificatesBase64;
    }

    @Bean
    @Primary
    @Qualifier(value="restTemplateWithKeystore")
    public RestTemplate restTemplateWithKeystore() {
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory((HttpClient)this.secureHttpClient);
        factory.setConnectionRequestTimeout(this.requestConnectionTimeout);
        factory.setConnectTimeout(this.requestConnectionTimeout);
        return new RestTemplate((ClientHttpRequestFactory)factory);
    }

    @Bean
    @Qualifier(value="restTemplateWithoutKeystore")
    public RestTemplate restTemplateWithoutKeystore() {
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory((HttpClient)this.secureHttpClientWithoutKeystore);
        factory.setConnectionRequestTimeout(this.requestConnectionTimeout);
        factory.setConnectTimeout(this.requestConnectionTimeout);
        return new RestTemplate((ClientHttpRequestFactory)factory);
    }

    @Bean
    @Primary
    @Qualifier(value="secureHttpClientWithKeystore")
    public CloseableHttpClient secureHttpClient() {
        return this.secureHttpClient;
    }

    @Bean
    @Qualifier(value="secureHttpClientWithoutKeystore")
    public CloseableHttpClient secureHttpClientWithoutKeystore() {
        return this.secureHttpClientWithoutKeystore;
    }

    @Bean
    public SSLContext secureSslContext() {
        return this.secureSslContext;
    }

    @Bean
    public HostnameVerifier secureHostnameVerifier() {
        return this.secureHostnameVerifier;
    }

    @Generated
    public SSLContext getSecureSslContext() {
        return this.secureSslContext;
    }

    @Generated
    public HostnameVerifier getSecureHostnameVerifier() {
        return this.secureHostnameVerifier;
    }
}

