/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.product.web;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.netflix.eureka.RestTemplateTimeoutProperties;
import org.springframework.cloud.netflix.eureka.http.DefaultEurekaClientHttpRequestFactorySupplier;
import org.springframework.cloud.netflix.eureka.http.EurekaClientHttpRequestFactorySupplier;
import org.springframework.cloud.netflix.eureka.http.RestTemplateDiscoveryClientOptionalArgs;
import org.springframework.cloud.netflix.eureka.http.RestTemplateTransportClientFactories;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.zowe.apiml.message.core.MessageService;
import org.zowe.apiml.message.log.ApimlLogger;
import org.zowe.apiml.message.yaml.YamlMessageServiceInstance;

@Configuration
public class DiscoveryRestTemplateConfig {
    private static final ApimlLogger apimlLog = ApimlLogger.of(DiscoveryRestTemplateConfig.class, (MessageService)YamlMessageServiceInstance.getInstance());

    @Bean
    public RestTemplateTransportClientFactories restTemplateTransportClientFactories(RestTemplateDiscoveryClientOptionalArgs restTemplateDiscoveryClientOptionalArgs) {
        return new RestTemplateTransportClientFactories(restTemplateDiscoveryClientOptionalArgs);
    }

    @Bean
    public RestTemplateDiscoveryClientOptionalArgs defaultArgs(@Value(value="${eureka.client.serviceUrl.defaultZone}") String eurekaServerUrl, SSLContext secureSslContext, HostnameVerifier secureHostnameVerifier) {
        RestTemplateDiscoveryClientOptionalArgs clientArgs = new RestTemplateDiscoveryClientOptionalArgs((EurekaClientHttpRequestFactorySupplier)DiscoveryRestTemplateConfig.getDefaultEurekaClientHttpRequestFactorySupplier());
        if (eurekaServerUrl.startsWith("http://")) {
            apimlLog.log("org.zowe.apiml.common.insecureHttpWarning", new Object[0]);
        } else {
            System.setProperty("com.netflix.eureka.shouldSSLConnectionsUseSystemSocketFactory", "true");
            clientArgs.setSSLContext(secureSslContext);
            clientArgs.setHostnameVerifier(secureHostnameVerifier);
        }
        return clientArgs;
    }

    private static DefaultEurekaClientHttpRequestFactorySupplier getDefaultEurekaClientHttpRequestFactorySupplier() {
        RestTemplateTimeoutProperties properties = new RestTemplateTimeoutProperties();
        properties.setConnectTimeout(180000);
        properties.setConnectRequestTimeout(180000);
        properties.setSocketTimeout(180000);
        return new DefaultEurekaClientHttpRequestFactorySupplier(properties);
    }
}

