/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.product.eureka.client;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.shared.transport.EurekaHttpResponse;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.cluster.HttpReplicationClient;
import com.netflix.eureka.cluster.PeerEurekaNode;
import com.netflix.eureka.cluster.protocol.ReplicationInstance;
import com.netflix.eureka.cluster.protocol.ReplicationInstanceResponse;
import com.netflix.eureka.cluster.protocol.ReplicationList;
import com.netflix.eureka.cluster.protocol.ReplicationListResponse;
import com.netflix.eureka.registry.PeerAwareInstanceRegistry;
import com.netflix.eureka.registry.PeerAwareInstanceRegistryImpl;
import com.netflix.eureka.resources.ASGResource;
import com.netflix.eureka.util.batcher.TaskDispatcher;
import com.netflix.eureka.util.batcher.TaskDispatchers;
import com.netflix.eureka.util.batcher.TaskProcessor;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zowe.apiml.product.eureka.client.AsgReplicationTask;
import org.zowe.apiml.product.eureka.client.InstanceReplicationTask;
import org.zowe.apiml.product.eureka.client.ReplicationTask;

public class ApimlPeerEurekaNode
extends PeerEurekaNode {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApimlPeerEurekaNode.class);
    private static final long RETRY_SLEEP_TIME_MS = 100L;
    private static final long SERVER_UNAVAILABLE_SLEEP_TIME_MS = 1000L;
    private static final long MAX_BATCHING_DELAY_MS = 500L;
    private static final int BATCH_SIZE = 250;
    private final String serviceUrl;
    private final EurekaServerConfig config;
    private final long maxProcessingDelayMs;
    private final PeerAwareInstanceRegistry registry;
    private final String targetHost;
    private final HttpReplicationClient replicationClient;
    private final TaskDispatcher<String, ReplicationTask> batchingDispatcher;
    private final TaskDispatcher<String, ReplicationTask> nonBatchingDispatcher;

    public ApimlPeerEurekaNode(PeerAwareInstanceRegistry registry, String targetHost, String serviceUrl, HttpReplicationClient replicationClient, EurekaServerConfig config, int maxPeerRetries) {
        this(registry, targetHost, serviceUrl, replicationClient, config, 250, 500L, 100L, 1000L, maxPeerRetries);
    }

    ApimlPeerEurekaNode(PeerAwareInstanceRegistry registry, String targetHost, String serviceUrl, HttpReplicationClient replicationClient, EurekaServerConfig config, int batchSize, long maxBatchingDelayMs, long retrySleepTimeMs, long serverUnavailableSleepTimeMs, int maxPeerRetries) {
        super(registry, targetHost, serviceUrl, replicationClient, config);
        this.registry = registry;
        this.targetHost = targetHost;
        this.replicationClient = replicationClient;
        this.serviceUrl = serviceUrl;
        this.config = config;
        this.maxProcessingDelayMs = config.getMaxTimeForReplication();
        String batcherName = this.getBatcherName();
        ReplicationTaskProcessor taskProcessor = new ReplicationTaskProcessor(targetHost, replicationClient, maxPeerRetries);
        this.batchingDispatcher = TaskDispatchers.createBatchingTaskDispatcher((String)batcherName, (int)config.getMaxElementsInPeerReplicationPool(), (int)batchSize, (int)config.getMaxThreadsForPeerReplication(), (long)maxBatchingDelayMs, (long)serverUnavailableSleepTimeMs, (long)retrySleepTimeMs, (TaskProcessor)taskProcessor);
        this.nonBatchingDispatcher = TaskDispatchers.createNonBatchingTaskDispatcher((String)targetHost, (int)config.getMaxElementsInStatusReplicationPool(), (int)config.getMaxThreadsForStatusReplication(), (long)maxBatchingDelayMs, (long)serverUnavailableSleepTimeMs, (long)retrySleepTimeMs, (TaskProcessor)taskProcessor);
    }

    public void register(final InstanceInfo info) throws Exception {
        long expiryTime = System.currentTimeMillis() + (long)ApimlPeerEurekaNode.getLeaseRenewalOf(info);
        this.batchingDispatcher.process((Object)ApimlPeerEurekaNode.taskId("register", info), (Object)new InstanceReplicationTask(this.targetHost, PeerAwareInstanceRegistryImpl.Action.Register, info, null, true){

            public EurekaHttpResponse<Void> execute() {
                return ApimlPeerEurekaNode.this.replicationClient.register(info);
            }
        }, expiryTime);
    }

    public void cancel(final String appName, final String id) throws Exception {
        long expiryTime = System.currentTimeMillis() + this.maxProcessingDelayMs;
        this.batchingDispatcher.process((Object)ApimlPeerEurekaNode.taskId("cancel", appName, id), (Object)new InstanceReplicationTask(this.targetHost, PeerAwareInstanceRegistryImpl.Action.Cancel, appName, id){

            public EurekaHttpResponse<Void> execute() {
                return ApimlPeerEurekaNode.this.replicationClient.cancel(appName, id);
            }

            @Override
            public void handleFailure(int statusCode, Object responseEntity) throws Throwable {
                super.handleFailure(statusCode, responseEntity);
                if (statusCode == 404) {
                    log.warn("{}: missing entry.", (Object)this.getTaskName());
                }
            }
        }, expiryTime);
    }

    public void heartbeat(final String appName, final String id, final InstanceInfo info, final InstanceInfo.InstanceStatus overriddenStatus, boolean primeConnection) throws Throwable {
        if (primeConnection) {
            this.replicationClient.sendHeartBeat(appName, id, info, overriddenStatus);
            return;
        }
        InstanceReplicationTask replicationTask = new InstanceReplicationTask(this.targetHost, PeerAwareInstanceRegistryImpl.Action.Heartbeat, info, overriddenStatus, false){

            public EurekaHttpResponse<InstanceInfo> execute() throws Throwable {
                return ApimlPeerEurekaNode.this.replicationClient.sendHeartBeat(appName, id, info, overriddenStatus);
            }

            @Override
            public void handleFailure(int statusCode, Object responseEntity) throws Throwable {
                InstanceInfo peerInstanceInfo;
                super.handleFailure(statusCode, responseEntity);
                if (statusCode == 404) {
                    log.warn("{}: missing entry.", (Object)this.getTaskName());
                    if (info != null) {
                        log.warn("{}: cannot find instance id {} and hence replicating the instance with status {}", new Object[]{this.getTaskName(), info.getId(), info.getStatus()});
                        ApimlPeerEurekaNode.this.register(info);
                    }
                } else if (ApimlPeerEurekaNode.this.config.shouldSyncWhenTimestampDiffers() && (peerInstanceInfo = (InstanceInfo)responseEntity) != null) {
                    ApimlPeerEurekaNode.this.syncInstancesWhenTimestampDiffers(appName, id, info, peerInstanceInfo);
                }
            }
        };
        long expiryTime = System.currentTimeMillis() + (long)ApimlPeerEurekaNode.getLeaseRenewalOf(info);
        log.debug("Heartbeat update");
        this.batchingDispatcher.process((Object)ApimlPeerEurekaNode.taskId("heartbeat", info), (Object)replicationTask, expiryTime);
    }

    public void statusUpdate(final String asgName, final ASGResource.ASGStatus newStatus) {
        long expiryTime = System.currentTimeMillis() + this.maxProcessingDelayMs;
        this.nonBatchingDispatcher.process((Object)asgName, (Object)new AsgReplicationTask(this.targetHost, PeerAwareInstanceRegistryImpl.Action.StatusUpdate, asgName, newStatus){

            @Override
            public EurekaHttpResponse<?> execute() {
                return ApimlPeerEurekaNode.this.replicationClient.statusUpdate(asgName, newStatus);
            }
        }, expiryTime);
    }

    public void statusUpdate(final String appName, final String id, final InstanceInfo.InstanceStatus newStatus, final InstanceInfo info) {
        long expiryTime = System.currentTimeMillis() + this.maxProcessingDelayMs;
        this.batchingDispatcher.process((Object)ApimlPeerEurekaNode.taskId("statusUpdate", appName, id), (Object)new InstanceReplicationTask(this.targetHost, PeerAwareInstanceRegistryImpl.Action.StatusUpdate, info, null, false){

            public EurekaHttpResponse<Void> execute() {
                return ApimlPeerEurekaNode.this.replicationClient.statusUpdate(appName, id, newStatus, info);
            }
        }, expiryTime);
    }

    public void deleteStatusOverride(final String appName, final String id, final InstanceInfo info) {
        long expiryTime = System.currentTimeMillis() + this.maxProcessingDelayMs;
        this.batchingDispatcher.process((Object)ApimlPeerEurekaNode.taskId("deleteStatusOverride", appName, id), (Object)new InstanceReplicationTask(this.targetHost, PeerAwareInstanceRegistryImpl.Action.DeleteStatusOverride, info, null, false){

            public EurekaHttpResponse<Void> execute() {
                return ApimlPeerEurekaNode.this.replicationClient.deleteStatusOverride(appName, id, info);
            }
        }, expiryTime);
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public void shutDown() {
        this.batchingDispatcher.shutdown();
        this.nonBatchingDispatcher.shutdown();
        this.replicationClient.shutdown();
    }

    private void syncInstancesWhenTimestampDiffers(String appName, String id, InstanceInfo info, InstanceInfo infoFromPeer) {
        try {
            log.warn("Peer wants us to take the instance information from it, since the timestamp differs,Id : {} My Timestamp : {}, Peer's timestamp: {}", new Object[]{id, info.getLastDirtyTimestamp(), infoFromPeer.getLastDirtyTimestamp()});
            if (infoFromPeer.getOverriddenStatus() != null && !InstanceInfo.InstanceStatus.UNKNOWN.equals((Object)infoFromPeer.getOverriddenStatus())) {
                log.warn("Overridden Status info -id {}, mine {}, peer's {}", new Object[]{id, info.getOverriddenStatus(), infoFromPeer.getOverriddenStatus()});
                this.registry.storeOverriddenStatusIfRequired(appName, id, infoFromPeer.getOverriddenStatus());
            }
            this.registry.register(infoFromPeer, true);
        }
        catch (Exception e) {
            log.warn("Exception when trying to set information from peer :", (Throwable)e);
        }
    }

    public String getBatcherName() {
        String batcherName;
        try {
            batcherName = new URL(this.serviceUrl).getHost();
        }
        catch (MalformedURLException e1) {
            batcherName = this.serviceUrl;
        }
        return "target_" + batcherName;
    }

    private static String taskId(String requestType, String appName, String id) {
        return requestType + '#' + appName + '/' + id;
    }

    private static String taskId(String requestType, InstanceInfo info) {
        return ApimlPeerEurekaNode.taskId(requestType, info.getAppName(), info.getId());
    }

    private static int getLeaseRenewalOf(InstanceInfo info) {
        return (info.getLeaseInfo() == null ? 90 : info.getLeaseInfo().getRenewalIntervalInSecs()) * 1000;
    }

    public static class ReplicationTaskProcessor
    implements TaskProcessor<ReplicationTask> {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(ReplicationTaskProcessor.class);
        private final HttpReplicationClient replicationClient;
        private final String peerId;
        private volatile long lastNetworkErrorTime;
        private static final Pattern READ_TIME_OUT_PATTERN = Pattern.compile(".*read.*time.*out.*");
        private final NetworkIssueCounter networkIssueCounter = new NetworkIssueCounter();
        private final int maxPeerRetries;

        public ReplicationTaskProcessor(String peerId, HttpReplicationClient replicationClient, int maxPeerRetries) {
            this.replicationClient = replicationClient;
            this.peerId = peerId;
            this.maxPeerRetries = maxPeerRetries;
        }

        public TaskProcessor.ProcessingResult process(ReplicationTask task) {
            try {
                EurekaHttpResponse<?> httpResponse = task.execute();
                int statusCode = httpResponse.getStatusCode();
                Object entity = httpResponse.getEntity();
                log.debug("Replication task {} completed with status {}, (includes entity {})", new Object[]{task.getTaskName(), statusCode, entity != null});
                if (!ReplicationTaskProcessor.isSuccess(statusCode)) {
                    if (statusCode == 503) {
                        this.networkIssueCounter.fail("Service is not available");
                        log.debug("Server busy (503) reply for task {}", (Object)task.getTaskName());
                        return TaskProcessor.ProcessingResult.Congestion;
                    }
                    task.handleFailure(statusCode, entity);
                    return TaskProcessor.ProcessingResult.PermanentError;
                }
                this.networkIssueCounter.success();
                task.handleSuccess();
            }
            catch (Throwable e) {
                this.networkIssueCounter.fail(e.getLocalizedMessage());
                if (ReplicationTaskProcessor.maybeReadTimeOut(e)) {
                    log.error("It seems to be a socket read timeout exception, it will retry later. if it continues to happen and some eureka node occupied all the cpu time, you should set property 'eureka.server.peer-node-read-timeout-ms' to a bigger value", e);
                    return TaskProcessor.ProcessingResult.Congestion;
                }
                if (ReplicationTaskProcessor.isNetworkConnectException(e) && !this.networkIssueCounter.hasReachedMax()) {
                    this.logNetworkErrorSample(task, "; retrying after delay.", e);
                    return TaskProcessor.ProcessingResult.TransientError;
                }
                this.logNetworkErrorSample(task, "; not re-trying this exception because it does not seem to be a network exception.", e);
                return TaskProcessor.ProcessingResult.PermanentError;
            }
            return TaskProcessor.ProcessingResult.Success;
        }

        public TaskProcessor.ProcessingResult process(List<ReplicationTask> tasks) {
            ReplicationList list = this.createReplicationListOf(tasks);
            try {
                EurekaHttpResponse response = this.replicationClient.submitBatchUpdates(list);
                int statusCode = response.getStatusCode();
                if (!ReplicationTaskProcessor.isSuccess(statusCode)) {
                    if (statusCode == 503) {
                        this.networkIssueCounter.fail("Service is not available");
                        log.warn("Server busy (503) HTTP status code received from the peer {}; rescheduling tasks after delay", (Object)this.peerId);
                        return TaskProcessor.ProcessingResult.Congestion;
                    }
                    log.error("Batch update failure with HTTP status code {}; discarding {} replication tasks", (Object)statusCode, (Object)tasks.size());
                    return TaskProcessor.ProcessingResult.PermanentError;
                }
                this.networkIssueCounter.success();
                this.handleBatchResponse(tasks, ((ReplicationListResponse)response.getEntity()).getResponseList());
            }
            catch (Throwable e) {
                this.networkIssueCounter.fail(e.getLocalizedMessage());
                if (ReplicationTaskProcessor.maybeReadTimeOut(e)) {
                    log.error("It seems to be a socket read timeout exception, it will retry later. if it continues to happen and some eureka node occupied all the cpu time, you should set property 'eureka.server.peer-node-read-timeout-ms' to a bigger value", e);
                    return TaskProcessor.ProcessingResult.Congestion;
                }
                if (ReplicationTaskProcessor.isNetworkConnectException(e) && !this.networkIssueCounter.hasReachedMax()) {
                    this.logNetworkErrorSample(null, "; retrying after delay.", e);
                    return TaskProcessor.ProcessingResult.TransientError;
                }
                this.logNetworkErrorSample(null, "; not re-trying this exception because it does not seem to be a network exception.", e);
                return TaskProcessor.ProcessingResult.PermanentError;
            }
            return TaskProcessor.ProcessingResult.Success;
        }

        private void logNetworkErrorSample(ReplicationTask task, String additionalMessage, Throwable e) {
            long messageTimeout = 10000L;
            long now = System.currentTimeMillis();
            if (now - this.lastNetworkErrorTime > messageTimeout) {
                this.lastNetworkErrorTime = now;
                StringBuilder sb = new StringBuilder();
                sb.append("Network level connection to peer ").append(this.peerId);
                if (task != null) {
                    sb.append(" for task ").append(task.getTaskName());
                }
                sb.append(additionalMessage);
                sb.append(" This message will suppressed for ").append(messageTimeout).append("ms.");
                log.error(sb.toString(), e);
            }
        }

        private void handleBatchResponse(List<ReplicationTask> tasks, List<ReplicationInstanceResponse> responseList) {
            if (tasks.size() != responseList.size()) {
                log.error("Batch response size different from submitted task list ({} != {}); skipping response analysis", (Object)responseList.size(), (Object)tasks.size());
                return;
            }
            for (int i = 0; i < tasks.size(); ++i) {
                this.handleBatchResponse(tasks.get(i), responseList.get(i));
            }
        }

        private void handleBatchResponse(ReplicationTask task, ReplicationInstanceResponse response) {
            int statusCode = response.getStatusCode();
            if (ReplicationTaskProcessor.isSuccess(statusCode)) {
                task.handleSuccess();
                return;
            }
            try {
                task.handleFailure(response.getStatusCode(), response.getResponseEntity());
            }
            catch (Throwable e) {
                log.error("Replication task {} error handler failure", (Object)task.getTaskName(), (Object)e);
            }
        }

        private ReplicationList createReplicationListOf(List<ReplicationTask> tasks) {
            ReplicationList list = new ReplicationList();
            for (ReplicationTask task : tasks) {
                list.addReplicationInstance(ReplicationTaskProcessor.createReplicationInstanceOf((InstanceReplicationTask)task));
            }
            return list;
        }

        private static boolean isSuccess(int statusCode) {
            return statusCode >= 200 && statusCode < 300;
        }

        private static boolean isNetworkConnectException(Throwable e) {
            if (e instanceof IOException && !(e instanceof SSLException)) {
                return true;
            }
            Throwable cause = e.getCause();
            if (cause == null || cause == e) {
                return false;
            }
            return ReplicationTaskProcessor.isNetworkConnectException(cause);
        }

        private static boolean maybeReadTimeOut(Throwable e) {
            Matcher matcher;
            String message;
            if (e instanceof IOException && (message = e.getMessage()) != null && (matcher = READ_TIME_OUT_PATTERN.matcher(message.toLowerCase())).find()) {
                return true;
            }
            Throwable cause = e.getCause();
            if (cause == null || cause == e) {
                return false;
            }
            return ReplicationTaskProcessor.maybeReadTimeOut(cause);
        }

        private static ReplicationInstance createReplicationInstanceOf(InstanceReplicationTask task) {
            ReplicationInstance.ReplicationInstanceBuilder instanceBuilder = ReplicationInstance.ReplicationInstanceBuilder.aReplicationInstance();
            instanceBuilder.withAppName(task.getAppName());
            instanceBuilder.withId(task.getId());
            InstanceInfo instanceInfo = task.getInstanceInfo();
            if (instanceInfo != null) {
                String overriddenStatus = task.getOverriddenStatus() == null ? null : task.getOverriddenStatus().name();
                instanceBuilder.withOverriddenStatus(overriddenStatus);
                instanceBuilder.withLastDirtyTimestamp(instanceInfo.getLastDirtyTimestamp());
                if (task.shouldReplicateInstanceInfo()) {
                    instanceBuilder.withInstanceInfo(instanceInfo);
                }
                String instanceStatus = instanceInfo.getStatus() == null ? null : instanceInfo.getStatus().name();
                instanceBuilder.withStatus(instanceStatus);
            }
            instanceBuilder.withAction(task.getAction());
            return instanceBuilder.build();
        }

        class NetworkIssueCounter {
            final AtomicInteger counter = new AtomicInteger(0);

            NetworkIssueCounter() {
            }

            private String getCountText() {
                int count = this.counter.get();
                StringBuilder sb = new StringBuilder();
                sb.append(count);
                if (count >= ReplicationTaskProcessor.this.maxPeerRetries) {
                    sb.append('+');
                }
                return sb.toString();
            }

            public void success() {
                int count = this.counter.get();
                if (count > 0) {
                    log.trace("Network error indicator was reset. The number of errors was {}/{}", (Object)this.getCountText(), (Object)ReplicationTaskProcessor.this.maxPeerRetries);
                }
                this.counter.set(0);
            }

            public void fail(String errorMessage) {
                this.counter.getAndUpdate(prev -> Math.min(prev + 1, ReplicationTaskProcessor.this.maxPeerRetries));
                log.trace("Network error ({}) occurred. The number of errors is {}/{}. The network error status is considered as {}.", new Object[]{errorMessage, this.getCountText(), ReplicationTaskProcessor.this.maxPeerRetries, this.hasReachedMax() ? "permanent" : "temporary"});
            }

            public boolean hasReachedMax() {
                return this.counter.get() >= ReplicationTaskProcessor.this.maxPeerRetries;
            }
        }
    }
}

