/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.product.web;

import com.netflix.discovery.AbstractDiscoveryClientOptionalArgs;
import com.netflix.discovery.shared.transport.jersey.EurekaJerseyClient;
import com.netflix.discovery.shared.transport.jersey.EurekaJerseyClientImpl;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Resource;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;
import org.zowe.apiml.security.ApimlPoolingHttpClientConnectionManager;
import org.zowe.apiml.security.HttpsConfig;
import org.zowe.apiml.security.HttpsConfigError;
import org.zowe.apiml.security.HttpsFactory;
import org.zowe.apiml.security.SecurityUtils;

@Configuration
public class HttpConfig
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpConfig.class);
    private static final char[] KEYRING_PASSWORD = "password".toCharArray();
    @Value(value="${server.attlsClient.enabled:false}")
    private boolean isClientAttlsEnabled;
    @Value(value="${server.ssl.protocol:TLSv1.2}")
    private String protocol;
    @Value(value="${apiml.httpclient.ssl.enabled-protocols:TLSv1.2,TLSv1.3}")
    private String[] supportedProtocols;
    @Value(value="${server.ssl.ciphers:TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384,TLS_AES_128_GCM_SHA256,TLS_AES_256_GCM_SHA384}")
    private String[] ciphers;
    @Value(value="${server.ssl.trustStore:#{null}}")
    private String trustStore;
    @Value(value="${server.ssl.trustStorePassword:#{null}}")
    private char[] trustStorePassword;
    @Value(value="${server.ssl.trustStoreType:PKCS12}")
    private String trustStoreType;
    @Value(value="${server.ssl.keyAlias:#{null}}")
    private String keyAlias;
    @Value(value="${server.ssl.keyStore:#{null}}")
    private String keyStore;
    @Value(value="${server.ssl.keyStorePassword:#{null}}")
    private char[] keyStorePassword;
    @Value(value="${server.ssl.keyPassword:#{null}}")
    private char[] keyPassword;
    @Value(value="${server.ssl.keyStoreType:PKCS12}")
    private String keyStoreType;
    @Value(value="${apiml.security.ssl.verifySslCertificatesOfServices:true}")
    private boolean verifySslCertificatesOfServices;
    @Value(value="${apiml.security.ssl.nonStrictVerifySslCertificatesOfServices:false}")
    private boolean nonStrictVerifySslCertificatesOfServices;
    @Value(value="${spring.application.name}")
    private String serviceId;
    @Value(value="${server.ssl.trustStoreRequired:false}")
    private boolean trustStoreRequired;
    @Value(value="${eureka.client.serviceUrl.defaultZone}")
    private String eurekaServerUrl;
    @Value(value="${server.maxConnectionsPerRoute:#{10}}")
    private Integer maxConnectionsPerRoute;
    @Value(value="${server.maxTotalConnections:#{100}}")
    private Integer maxTotalConnections;
    @Value(value="${apiml.httpclient.conn-pool.idleConnTimeoutSeconds:#{5}}")
    private int idleConnTimeoutSeconds;
    @Value(value="${apiml.httpclient.conn-pool.requestConnectionTimeout:#{10000}}")
    private int requestConnectionTimeout;
    @Value(value="${apiml.httpclient.conn-pool.readTimeout:#{10000}}")
    private int readTimeout;
    @Value(value="${apiml.httpclient.conn-pool.timeToLive:#{10000}}")
    private int timeToLive;
    private HttpsFactory factory;
    private CloseableHttpClient secureHttpClient;
    private CloseableHttpClient secureHttpClientWithoutKeystore;
    private SSLContext secureSslContext;
    private SSLContext secureSslContextWithoutKeystore;
    private HostnameVerifier secureHostnameVerifier;
    private final Timer connectionManagerTimer = new Timer("ApimlHttpClientConfiguration.connectionManagerTimer", true);
    private Set<String> publicKeyCertificatesBase64;
    @Resource
    private AbstractDiscoveryClientOptionalArgs<?> optionalArgs;

    void updateStorePaths() {
        if (SecurityUtils.isKeyring((String)this.keyStore)) {
            this.keyStore = SecurityUtils.formatKeyringUrl((String)this.keyStore);
            if (this.keyStorePassword == null) {
                this.keyStorePassword = KEYRING_PASSWORD;
            }
        }
        if (SecurityUtils.isKeyring((String)this.trustStore)) {
            this.trustStore = SecurityUtils.formatKeyringUrl((String)this.trustStore);
            if (this.trustStorePassword == null) {
                this.trustStorePassword = KEYRING_PASSWORD;
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.init();
    }

    public void init() {
        this.updateStorePaths();
        try {
            Supplier<HttpsConfig.HttpsConfigBuilder> httpsConfigSupplier = () -> HttpsConfig.builder().protocol(this.protocol).enabledProtocols(this.supportedProtocols).cipherSuite(this.ciphers).trustStore(this.trustStore).trustStoreType(this.trustStoreType).trustStorePassword(this.trustStorePassword).trustStoreRequired(this.trustStoreRequired).verifySslCertificatesOfServices(this.verifySslCertificatesOfServices).nonStrictVerifySslCertificatesOfServices(this.nonStrictVerifySslCertificatesOfServices).maxConnectionsPerRoute(this.maxConnectionsPerRoute.intValue()).maxTotalConnections(this.maxTotalConnections.intValue()).idleConnTimeoutSeconds(this.idleConnTimeoutSeconds).requestConnectionTimeout(this.requestConnectionTimeout).timeToLive(this.timeToLive);
            HttpsConfig httpsConfig = httpsConfigSupplier.get().keyAlias(this.keyAlias).keyStore(this.keyStore).keyPassword(this.keyPassword).keyStorePassword(this.keyStorePassword).keyStoreType(this.keyStoreType).build();
            HttpsConfig httpsConfigWithoutKeystore = httpsConfigSupplier.get().build();
            log.info("Using HTTPS configuration: {}", (Object)httpsConfig.toString());
            this.factory = new HttpsFactory(httpsConfig);
            ApimlPoolingHttpClientConnectionManager secureConnectionManager = this.getConnectionManager(this.factory);
            this.secureHttpClient = this.factory.createSecureHttpClient((HttpClientConnectionManager)secureConnectionManager);
            this.secureSslContext = this.factory.getSslContext();
            this.secureHostnameVerifier = this.factory.getHostnameVerifier();
            this.optionalArgs.setEurekaJerseyClient(this.eurekaJerseyClient());
            HttpsFactory factoryWithoutKeystore = new HttpsFactory(httpsConfigWithoutKeystore);
            ApimlPoolingHttpClientConnectionManager connectionManagerWithoutKeystore = this.getConnectionManager(factoryWithoutKeystore);
            this.secureHttpClientWithoutKeystore = factoryWithoutKeystore.createSecureHttpClient((HttpClientConnectionManager)connectionManagerWithoutKeystore);
            this.secureSslContextWithoutKeystore = factoryWithoutKeystore.getSslContext();
            this.publicKeyCertificatesBase64 = SecurityUtils.loadCertificateChainBase64((HttpsConfig)httpsConfig);
        }
        catch (HttpsConfigError e) {
            log.error("Invalid configuration of HTTPs: {}", (Object)e.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            log.error("Cannot construct configuration of HTTPs: {}", (Object)e.getMessage());
            System.exit(1);
        }
    }

    public ApimlPoolingHttpClientConnectionManager getConnectionManager(HttpsFactory factory) {
        RegistryBuilder socketFactoryRegistryBuilder = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
        socketFactoryRegistryBuilder.register("https", (Object)factory.createSslSocketFactory());
        Registry socketFactoryRegistry = socketFactoryRegistryBuilder.build();
        final ApimlPoolingHttpClientConnectionManager connectionManager = new ApimlPoolingHttpClientConnectionManager(socketFactoryRegistry, this.timeToLive);
        this.connectionManagerTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                connectionManager.closeExpiredConnections();
                connectionManager.closeIdleConnections((long)HttpConfig.this.idleConnTimeoutSeconds, TimeUnit.SECONDS);
            }
        }, 30000L, 30000L);
        connectionManager.setDefaultMaxPerRoute(this.maxConnectionsPerRoute.intValue());
        connectionManager.setMaxTotal(this.maxTotalConnections.intValue());
        return connectionManager;
    }

    @Bean
    public Set<String> publicKeyCertificatesBase64() {
        return this.publicKeyCertificatesBase64;
    }

    private void setTruststore(SslContextFactory sslContextFactory) {
        if (StringUtils.isNotEmpty((CharSequence)this.trustStore)) {
            sslContextFactory.setTrustStorePath(SecurityUtils.formatKeyringUrl((String)this.trustStore));
            sslContextFactory.setTrustStoreType(this.trustStoreType);
            sslContextFactory.setTrustStorePassword(this.trustStorePassword == null ? null : String.valueOf(this.trustStorePassword));
        }
    }

    @Bean
    public SslContextFactory.Client jettyClientSslContextFactory() {
        SslContextFactory.Client sslContextFactory = new SslContextFactory.Client();
        sslContextFactory.setProtocol(this.protocol);
        sslContextFactory.setExcludeCipherSuites(new String[]{"^.*_(MD5|SHA|SHA1)$", "^TLS_RSA_.*$"});
        this.setTruststore((SslContextFactory)sslContextFactory);
        log.debug("jettySslContextFactory: {}", (Object)sslContextFactory.dump());
        sslContextFactory.setHostnameVerifier(this.secureHostnameVerifier());
        if (this.nonStrictVerifySslCertificatesOfServices) {
            sslContextFactory.setEndpointIdentificationAlgorithm(null);
        }
        if (!this.verifySslCertificatesOfServices) {
            sslContextFactory.setTrustAll(true);
        }
        return sslContextFactory;
    }

    @Bean
    @Primary
    public RestTemplate restTemplateWithKeystore() {
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory((HttpClient)this.secureHttpClient);
        factory.setReadTimeout(this.readTimeout);
        factory.setConnectTimeout(this.requestConnectionTimeout);
        return new RestTemplate((ClientHttpRequestFactory)factory);
    }

    @Bean
    public RestTemplate restTemplateWithoutKeystore() {
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory((HttpClient)this.secureHttpClientWithoutKeystore);
        factory.setReadTimeout(this.readTimeout);
        factory.setConnectTimeout(this.requestConnectionTimeout);
        return new RestTemplate((ClientHttpRequestFactory)factory);
    }

    @Bean(value={"secureHttpClientWithKeystore"})
    @Primary
    public CloseableHttpClient secureHttpClient() {
        return this.secureHttpClient;
    }

    @Bean
    public CloseableHttpClient secureHttpClientWithoutKeystore() {
        return this.secureHttpClientWithoutKeystore;
    }

    @Bean
    public SSLContext secureSslContext() {
        return this.secureSslContext;
    }

    @Bean
    public SSLContext secureSslContextWithoutKeystore() {
        return this.secureSslContextWithoutKeystore;
    }

    @Bean
    public HostnameVerifier secureHostnameVerifier() {
        return this.secureHostnameVerifier;
    }

    @Bean
    public EurekaJerseyClient eurekaJerseyClient() {
        return this.eurekaJerseyClientBuilder().get().build();
    }

    @Bean
    public Supplier<EurekaJerseyClientImpl.EurekaJerseyClientBuilder> eurekaJerseyClientBuilder() {
        return () -> this.factory.createEurekaJerseyClientBuilder(this.eurekaServerUrl, this.serviceId, this.isClientAttlsEnabled);
    }

    @Generated
    public String getTrustStore() {
        return this.trustStore;
    }

    @Generated
    public char[] getTrustStorePassword() {
        return this.trustStorePassword;
    }

    @Generated
    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    @Generated
    public String getKeyStore() {
        return this.keyStore;
    }

    @Generated
    public char[] getKeyStorePassword() {
        return this.keyStorePassword;
    }

    @Generated
    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    @Generated
    public boolean isVerifySslCertificatesOfServices() {
        return this.verifySslCertificatesOfServices;
    }

    @Generated
    public boolean isNonStrictVerifySslCertificatesOfServices() {
        return this.nonStrictVerifySslCertificatesOfServices;
    }
}

