/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.product.filter;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.filter.OncePerRequestFilter;

public class AttlsFilter
extends OncePerRequestFilter {
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        X509Certificate[] certificates = new X509Certificate[1];
        String clientCert = request.getHeader("X-SSL-CERT");
        if (clientCert != null) {
            try {
                clientCert = URLDecoder.decode(clientCert, StandardCharsets.UTF_8.name());
                ByteArrayInputStream targetStream = new ByteArrayInputStream(clientCert.getBytes());
                certificates[0] = (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(targetStream);
            }
            catch (Exception e) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            request.setAttribute("javax.servlet.request.X509Certificate", (Object)certificates);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

