/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.discovery.staticdef;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.eureka.EurekaServerContext;
import com.netflix.eureka.EurekaServerContextHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.zowe.apiml.discovery.ApimlInstanceRegistry;
import org.zowe.apiml.discovery.metadata.MetadataDefaultsService;
import org.zowe.apiml.discovery.staticdef.ServiceDefinitionProcessor;
import org.zowe.apiml.product.discovery.StaticRegistrationResult;
import org.zowe.apiml.product.discovery.StaticServicesRegistration;

@Component
public class StaticServicesRegistrationService
implements StaticServicesRegistration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StaticServicesRegistrationService.class);
    @Value(value="${apiml.discovery.staticApiDefinitionsDirectories:#{null}}")
    private String staticApiDefinitionsDirectories;
    private final ServiceDefinitionProcessor serviceDefinitionProcessor;
    private final MetadataDefaultsService metadataDefaultsService;
    private final List<InstanceInfo> staticInstances = new CopyOnWriteArrayList<InstanceInfo>();

    public StaticServicesRegistrationService(ServiceDefinitionProcessor serviceDefinitionProcessor, MetadataDefaultsService metadataDefaultsService) {
        this.serviceDefinitionProcessor = serviceDefinitionProcessor;
        this.metadataDefaultsService = metadataDefaultsService;
    }

    public List<InstanceInfo> getStaticInstances() {
        return this.staticInstances;
    }

    public void registerServices() {
        this.registerServices(this.staticApiDefinitionsDirectories);
    }

    public synchronized StaticRegistrationResult reloadServices() {
        ArrayList<InstanceInfo> oldStaticInstances = new ArrayList<InstanceInfo>(this.staticInstances);
        this.staticInstances.clear();
        StaticRegistrationResult result = this.registerServices(this.staticApiDefinitionsDirectories);
        ApimlInstanceRegistry registry = this.getRegistry();
        for (InstanceInfo info : oldStaticInstances) {
            if (result.getRegisteredServices().contains(info.getInstanceId())) continue;
            log.info("Instance {} is not defined in the new static API definitions. It will be removed", (Object)info.getInstanceId());
            registry.cancel(info.getAppName(), info.getId(), false);
        }
        return result;
    }

    StaticRegistrationResult registerServices(String staticApiDefinitionsDirectories) {
        ApimlInstanceRegistry registry = this.getRegistry();
        StaticRegistrationResult result = this.serviceDefinitionProcessor.findStaticServicesData(staticApiDefinitionsDirectories);
        Map additionalServiceMetadata = result.getAdditionalServiceMetadata();
        this.metadataDefaultsService.setAdditionalServiceMetadata(additionalServiceMetadata);
        for (InstanceInfo instanceInfo : result.getInstances()) {
            result.getRegisteredServices().add(instanceInfo.getInstanceId());
            this.staticInstances.add(instanceInfo);
            registry.registerStatically(instanceInfo, false, false);
        }
        return result;
    }

    private ApimlInstanceRegistry getRegistry() {
        return (ApimlInstanceRegistry)this.getServerContext().getRegistry();
    }

    private EurekaServerContext getServerContext() {
        return EurekaServerContextHolder.getInstance().getServerContext();
    }
}

