/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.discovery.config;

import jakarta.servlet.Filter;
import java.util.Arrays;
import java.util.Collections;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityCustomizer;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.SpringSecurityMessageSource;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.zowe.apiml.discovery.config.AbstractWebSecurityConfigurer;
import org.zowe.apiml.security.common.config.HandlerInitializer;
import org.zowe.apiml.security.common.content.BasicContentFilter;

@Configuration
@Profile(value={"!https & !attlsServer"})
@ConditionalOnMissingBean(name={"modulithConfig"})
public class HttpWebSecurityConfig
extends AbstractWebSecurityConfigurer {
    private static final String DISCOVERY_REALM = "API Mediation Discovery Service realm";
    @Value(value="${apiml.discovery.userid:eureka}")
    private String eurekaUserid;
    @Value(value="${apiml.discovery.password:password}")
    private char[] eurekaPassword;
    @Value(value="${apiml.health.protected:true}")
    private boolean isHealthEndpointProtected;
    private final HandlerInitializer handlerInitializer;

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) {
        auth.authenticationProvider(new AuthenticationProvider(){
            private MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();

            public Authentication authenticate(Authentication authentication) throws AuthenticationException {
                char[] credentials;
                if (StringUtils.equals((CharSequence)HttpWebSecurityConfig.this.eurekaUserid, (CharSequence)String.valueOf(authentication.getPrincipal())) && authentication.getCredentials() != null && Arrays.equals(HttpWebSecurityConfig.this.eurekaPassword, credentials = authentication.getCredentials() instanceof char[] ? (char[])authentication.getCredentials() : String.valueOf(authentication.getCredentials()).toCharArray())) {
                    UsernamePasswordAuthenticationToken result = UsernamePasswordAuthenticationToken.authenticated((Object)authentication.getPrincipal(), (Object)authentication.getCredentials(), Collections.singleton(new SimpleGrantedAuthority("EUREKA")));
                    result.setDetails(authentication.getDetails());
                    return result;
                }
                throw new BadCredentialsException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.badCredentials", "Bad credentials"));
            }

            public boolean supports(Class<?> authentication) {
                return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
            }
        });
    }

    @Bean
    public WebSecurityCustomizer httpWebSecurityCustomizer() {
        String[] noSecurityAntMatchers = new String[]{"/favicon.ico", "/eureka/css/**", "/eureka/js/**", "/eureka/fonts/**", "/eureka/images/**"};
        return web -> web.ignoring().requestMatchers(noSecurityAntMatchers);
    }

    @Bean
    public SecurityFilterChain httpFilterChain(HttpSecurity http) throws Exception {
        if (!this.isHealthEndpointProtected) {
            http.authorizeHttpRequests(requests -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.requestMatchers(new String[]{"/application/health"})).permitAll());
        }
        this.baseConfigure(http).httpBasic(s -> s.realmName(DISCOVERY_REALM)).authorizeHttpRequests(s -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)s.requestMatchers(new String[]{"/application/info"})).permitAll().requestMatchers(new String[]{"/**"})).authenticated());
        return (SecurityFilterChain)((HttpSecurity)http.with((SecurityConfigurerAdapter)new CustomSecurityFilters(), t -> {})).build();
    }

    @Generated
    public HttpWebSecurityConfig(HandlerInitializer handlerInitializer) {
        this.handlerInitializer = handlerInitializer;
    }

    private class CustomSecurityFilters
    extends AbstractHttpConfigurer<CustomSecurityFilters, HttpSecurity> {
        private CustomSecurityFilters() {
        }

        public void configure(HttpSecurity http) {
            AuthenticationManager authenticationManager = (AuthenticationManager)http.getSharedObject(AuthenticationManager.class);
            http.addFilterBefore((Filter)this.basicFilter(authenticationManager), UsernamePasswordAuthenticationFilter.class);
        }

        private BasicContentFilter basicFilter(AuthenticationManager authenticationManager) {
            return new BasicContentFilter(authenticationManager, (AuthenticationFailureHandler)HttpWebSecurityConfig.this.handlerInitializer.getAuthenticationFailureHandler(), HttpWebSecurityConfig.this.handlerInitializer.getResourceAccessExceptionHandler());
        }
    }
}

