/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.discovery.metadata;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.zowe.apiml.auth.AuthenticationScheme;

@Service
public class MetadataTranslationService {
    public void translateMetadata(String serviceId, Map<String, String> metadata) {
        String version = metadata.get("version");
        if (version == null) {
            this.translateV1toV2(metadata);
        }
        this.updateZosmfAuthentication(serviceId, metadata);
    }

    private void translateV1toV2(Map<String, String> metadata) {
        this.translateRoutes(metadata);
        this.translateParameter("mfaas.discovery.catalogUiTile.id", "apiml.catalog.tile.id", metadata);
        this.translateParameter("mfaas.discovery.catalogUiTile.version", "apiml.catalog.tile.version", metadata);
        this.translateParameter("mfaas.discovery.catalogUiTile.title", "apiml.catalog.tile.title", metadata);
        this.translateParameter("mfaas.discovery.catalogUiTile.description", "apiml.catalog.tile.description", metadata);
        this.translateParameter("mfaas.discovery.service.title", "apiml.service.title", metadata);
        this.translateParameter("mfaas.discovery.service.description", "apiml.service.description", metadata);
        metadata.remove("mfaas.api-info.apiVersionProperties.v1.basePackage");
        metadata.remove("mfaas.api-info.apiVersionProperties.v1.title");
        metadata.remove("mfaas.api-info.apiVersionProperties.v1.version");
        metadata.remove("mfaas.api-info.apiVersionProperties.v1.description");
        metadata.remove("mfaas.discovery.enableApiDoc");
    }

    private void translateRoutes(Map<String, String> metadata) {
        Map<String, String> newRoutes = metadata.entrySet().stream().filter(entry -> ((String)entry.getKey()).contains("routed-services")).collect(Collectors.toMap(this::translateRouteMapKey, Map.Entry::getValue));
        metadata.putAll(newRoutes);
        metadata.keySet().removeIf(key -> key.contains("routed-services"));
    }

    private String translateRouteMapKey(Map.Entry<String, String> map) {
        return map.getKey().replace("routed-services", "apiml.routes").replace("gateway-url", "gatewayUrl").replace("service-url", "serviceUrl");
    }

    private void translateParameter(String oldParameter, String newParameter, Map<String, String> metadata) {
        String parameterValue = metadata.get(oldParameter);
        if (parameterValue != null) {
            metadata.remove(oldParameter);
            metadata.put(newParameter, parameterValue);
        }
    }

    protected void updateZosmfAuthentication(String serviceId, Map<String, String> metadata) {
        if (!StringUtils.containsIgnoreCase((String)serviceId, (String)"zosmf")) {
            return;
        }
        if (metadata.containsKey("apiml.authentication.scheme")) {
            return;
        }
        metadata.put("apiml.authentication.scheme", AuthenticationScheme.ZOSMF.getScheme());
    }
}

