/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.discovery;

import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.netflix.eureka.server.event.EurekaRegistryAvailableEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;
import org.zowe.apiml.discovery.staticdef.StaticServicesRegistrationService;
import org.zowe.apiml.product.service.ServiceStartupEventHandler;

@Component
@ConditionalOnMissingBean(name={"modulithConfig"})
public class EurekaRegistryAvailableListener
implements ApplicationListener<EurekaRegistryAvailableEvent> {
    private final StaticServicesRegistrationService registrationService;
    private final AtomicBoolean startUpInfoPublished = new AtomicBoolean(false);

    public void onApplicationEvent(EurekaRegistryAvailableEvent event) {
        this.registrationService.registerServices();
        if (this.startUpInfoPublished.compareAndSet(false, true)) {
            new ServiceStartupEventHandler().onServiceStartup("Discovery Service", 5);
        }
    }

    @Generated
    public EurekaRegistryAvailableListener(StaticServicesRegistrationService registrationService) {
        this.registrationService = registrationService;
    }
}

