/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.discovery.metadata;

import java.util.Collections;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.zowe.apiml.discovery.staticdef.ServiceOverrideData;

@Service
public class MetadataDefaultsService {
    private Map<String, ServiceOverrideData> additionalServiceMetadata = Collections.emptyMap();

    public void updateMetadata(String serviceId, Map<String, String> metadata) {
        ServiceOverrideData sod = this.additionalServiceMetadata.get(serviceId);
        if (sod != null) {
            this.update(sod, metadata);
        }
    }

    private void update(ServiceOverrideData sod, Map<String, String> metadata) {
        switch (sod.getMode()) {
            case FORCE_UPDATE: {
                metadata.putAll(sod.getMetadata());
                break;
            }
            default: {
                for (Map.Entry<String, String> entry : sod.getMetadata().entrySet()) {
                    if (metadata.containsKey(entry.getKey())) continue;
                    metadata.put(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    public void setAdditionalServiceMetadata(Map<String, ServiceOverrideData> additionalServiceMetadata) {
        this.additionalServiceMetadata = Collections.unmodifiableMap(additionalServiceMetadata);
    }
}

