/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.discovery.staticdef;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.zowe.apiml.discovery.staticdef.StaticRegistrationResult;
import org.zowe.apiml.discovery.staticdef.StaticServicesRegistrationService;

@RestController
@RequestMapping(value={"/discovery/api/v1/staticApi"})
public class StaticApiRestController {
    private final StaticServicesRegistrationService registrationService;

    @Autowired
    public StaticApiRestController(StaticServicesRegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    @GetMapping
    @HystrixCommand
    public List<InstanceInfo> list() {
        return this.registrationService.getStaticInstances();
    }

    @PostMapping
    @HystrixCommand
    public StaticRegistrationResult reload() {
        return this.registrationService.reloadServices();
    }
}

