/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.discovery;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.springframework.cloud.netflix.eureka.server.event.EurekaInstanceRegisteredEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.zowe.apiml.discovery.EurekaStatusUpdateEvent;
import org.zowe.apiml.discovery.GatewayNotifier;
import org.zowe.apiml.discovery.metadata.MetadataDefaultsService;
import org.zowe.apiml.discovery.metadata.MetadataTranslationService;
import org.zowe.apiml.util.EurekaUtils;

@Component
public class EurekaInstanceRegisteredListener {
    private final MetadataTranslationService metadataTranslationService;
    private final MetadataDefaultsService metadataDefaultsService;
    private final GatewayNotifier gatewayNotifier;

    @EventListener
    @HystrixCommand
    public void listen(EurekaInstanceRegisteredEvent event) {
        InstanceInfo instanceInfo = event.getInstanceInfo();
        Map metadata = instanceInfo.getMetadata();
        String serviceId = EurekaUtils.getServiceIdFromInstanceId((String)instanceInfo.getInstanceId());
        this.metadataTranslationService.translateMetadata(serviceId, metadata);
        this.metadataDefaultsService.updateMetadata(serviceId, metadata);
        if (StringUtils.equalsIgnoreCase((String)GatewayNotifier.GATEWAY_SERVICE_ID, (String)serviceId)) {
            this.gatewayNotifier.distributeInvalidatedCredentials(instanceInfo.getInstanceId());
        }
        this.gatewayNotifier.serviceUpdated(serviceId, instanceInfo.getInstanceId());
    }

    @EventListener
    @HystrixCommand
    public void listen(EurekaStatusUpdateEvent event) {
        String serviceId = EurekaUtils.getServiceIdFromInstanceId((String)event.getInstanceId());
        this.gatewayNotifier.serviceUpdated(serviceId, event.getInstanceId());
    }

    @Generated
    public EurekaInstanceRegisteredListener(MetadataTranslationService metadataTranslationService, MetadataDefaultsService metadataDefaultsService, GatewayNotifier gatewayNotifier) {
        this.metadataTranslationService = metadataTranslationService;
        this.metadataDefaultsService = metadataDefaultsService;
        this.gatewayNotifier = gatewayNotifier;
    }
}

