/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.discovery.eureka;

import com.netflix.appinfo.AbstractEurekaIdentity;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.EurekaIdentityHeaderFilter;
import com.netflix.discovery.converters.wrappers.DecoderWrapper;
import com.netflix.discovery.converters.wrappers.EncoderWrapper;
import com.netflix.discovery.shared.transport.jersey.EurekaJerseyClient;
import com.netflix.discovery.shared.transport.jersey.EurekaJerseyClientImpl;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.EurekaServerIdentity;
import com.netflix.eureka.cluster.DynamicGZIPContentEncodingFilter;
import com.netflix.eureka.cluster.HttpReplicationClient;
import com.netflix.eureka.cluster.PeerEurekaNode;
import com.netflix.eureka.cluster.PeerEurekaNodes;
import com.netflix.eureka.registry.PeerAwareInstanceRegistry;
import com.netflix.eureka.resources.ServerCodecs;
import com.netflix.eureka.transport.JerseyReplicationClient;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.client.apache4.ApacheHttpClient4;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Set;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.cloud.netflix.eureka.server.ReplicationClientAdditionalFilters;
import org.springframework.context.ApplicationListener;
import org.zowe.apiml.product.eureka.client.ApimlPeerEurekaNode;

public class RefreshablePeerEurekaNodes
extends PeerEurekaNodes
implements ApplicationListener<EnvironmentChangeEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RefreshablePeerEurekaNodes.class);
    private Supplier<EurekaJerseyClientImpl.EurekaJerseyClientBuilder> eurekaJerseyClientBuilder;
    private ReplicationClientAdditionalFilters replicationClientAdditionalFilters;
    private int maxPeerRetries;

    public RefreshablePeerEurekaNodes(Supplier<EurekaJerseyClientImpl.EurekaJerseyClientBuilder> eurekaJerseyClientBuilder, PeerAwareInstanceRegistry registry, EurekaServerConfig serverConfig, EurekaClientConfig clientConfig, ServerCodecs serverCodecs, ApplicationInfoManager applicationInfoManager, ReplicationClientAdditionalFilters replicationClientAdditionalFilters, int maxPeerRetries) {
        super(registry, serverConfig, clientConfig, serverCodecs, applicationInfoManager);
        this.eurekaJerseyClientBuilder = eurekaJerseyClientBuilder;
        this.replicationClientAdditionalFilters = replicationClientAdditionalFilters;
        this.maxPeerRetries = maxPeerRetries;
    }

    private JerseyReplicationClient createReplicationClient(EurekaServerConfig config, ServerCodecs serverCodecs, String serviceUrl) {
        EurekaJerseyClient jerseyClient;
        String name = JerseyReplicationClient.class.getSimpleName() + ": " + serviceUrl + "apps/: ";
        try {
            String hostname;
            try {
                hostname = new URL(serviceUrl).getHost();
            }
            catch (MalformedURLException e) {
                hostname = serviceUrl;
            }
            String jerseyClientName = "Discovery-PeerNodeClient-" + hostname;
            EurekaJerseyClientImpl.EurekaJerseyClientBuilder clientBuilder = this.eurekaJerseyClientBuilder.get().withClientName(jerseyClientName).withUserAgent("Java-EurekaClient-Replication").withEncoderWrapper((EncoderWrapper)serverCodecs.getFullJsonCodec()).withDecoderWrapper((DecoderWrapper)serverCodecs.getFullJsonCodec()).withConnectionTimeout(config.getPeerNodeConnectTimeoutMs()).withReadTimeout(config.getPeerNodeReadTimeoutMs()).withMaxConnectionsPerHost(config.getPeerNodeTotalConnectionsPerHost()).withMaxTotalConnections(config.getPeerNodeTotalConnections()).withConnectionIdleTimeout(config.getPeerNodeConnectionIdleTimeoutSeconds());
            if (serviceUrl.startsWith("https://") && "true".equals(System.getProperty("com.netflix.eureka.shouldSSLConnectionsUseSystemSocketFactory"))) {
                clientBuilder.withSystemSSLConfiguration();
            }
            jerseyClient = clientBuilder.build();
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot Create new Replica Node :" + name, e);
        }
        String ip = null;
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            log.warn("Cannot find localhost ip", (Throwable)e);
        }
        ApacheHttpClient4 jerseyApacheClient = jerseyClient.getClient();
        jerseyApacheClient.addFilter((ClientFilter)new DynamicGZIPContentEncodingFilter(config));
        EurekaServerIdentity identity = new EurekaServerIdentity(ip);
        jerseyApacheClient.addFilter((ClientFilter)new EurekaIdentityHeaderFilter((AbstractEurekaIdentity)identity));
        return new JerseyReplicationClient(jerseyClient, serviceUrl);
    }

    public PeerEurekaNode createPeerEurekaNode(String peerEurekaNodeUrl) {
        JerseyReplicationClient replicationClient = this.createReplicationClient(this.serverConfig, this.serverCodecs, peerEurekaNodeUrl);
        this.replicationClientAdditionalFilters.getFilters().forEach(arg_0 -> ((JerseyReplicationClient)replicationClient).addReplicationClientFilter(arg_0));
        String targetHost = RefreshablePeerEurekaNodes.hostFromUrl((String)peerEurekaNodeUrl);
        if (targetHost == null) {
            targetHost = "host";
        }
        return new ApimlPeerEurekaNode(this.registry, targetHost, peerEurekaNodeUrl, (HttpReplicationClient)replicationClient, this.serverConfig, this.maxPeerRetries);
    }

    public void onApplicationEvent(EnvironmentChangeEvent event) {
        if (this.shouldUpdate(event.getKeys())) {
            this.updatePeerEurekaNodes(this.resolvePeerUrls());
        }
    }

    public boolean shouldUpdate(Set<String> changedKeys) {
        assert (changedKeys != null);
        if (this.clientConfig.shouldUseDnsForFetchingServiceUrls()) {
            return false;
        }
        if (changedKeys.contains("eureka.client.region")) {
            return true;
        }
        for (String key : changedKeys) {
            if (!key.startsWith("eureka.client.service-url.") && !key.startsWith("eureka.client.availability-zones.")) continue;
            return true;
        }
        return false;
    }
}

